/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflection;
import gov.nih.nlm.nls.lvg.Db.DbUninflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import gov.nih.nlm.nls.lvg.Util.LvgComparator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToUninflectWords
extends Transformation {
    private static final String INFO = "Uninflect Words";

    public static Vector Mutate(LexItem lexItem, int n, Connection connection, RamTrie ramTrie, boolean bl, boolean bl2) throws SQLException {
        Vector vector = ToUninflectWords.UninflectWords(lexItem.GetSourceTerm(), connection, ramTrie, n);
        Vector<LexItem> vector2 = new Vector<LexItem>();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            String string2 = null;
            String string3 = null;
            if (bl) {
                string2 = INFO;
            }
            if (bl2) {
                string3 = Transformation.NO_MUTATE_INFO;
            }
            LexItem lexItem2 = Transformation.UpdateLexItem(lexItem, string, 8, 2047L, Inflection.GetBitValue(0), string2, string3);
            vector2.addElement(lexItem2);
            ++n2;
        }
        return vector2;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "Left Data");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        int n2 = Integer.parseInt(configuration.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS"));
        LexItem lexItem = new LexItem(string);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            boolean bl = true;
            RamTrie ramTrie = new RamTrie(bl, n, string2, 0);
            if (connection != null) {
                vector = ToUninflectWords.Mutate(lexItem, n2, connection, ramTrie, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    protected static Vector FormCombinations(Vector vector) {
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            int n2 = vector.size() - 1 - n;
            Vector vector3 = (Vector)vector.elementAt(n2);
            int n3 = vector3.size();
            if (n == 0) {
                vector2.addAll(vector3);
            } else {
                Vector vector4 = new Vector(vector2);
                int n4 = vector4.size();
                int n5 = 1;
                while (n5 < n3) {
                    vector2.addAll(vector4);
                    ++n5;
                }
                int n6 = 0;
                while (n6 < vector2.size()) {
                    String string = null;
                    if (n3 > 0) {
                        string = (String)vector3.elementAt(n6 / n4);
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string);
                    stringBuffer.append(" ");
                    stringBuffer.append((String)vector2.elementAt(n6));
                    String string2 = stringBuffer.toString();
                    vector2.setElementAt(string2, n6);
                    ++n6;
                }
            }
            ++n;
        }
        return vector2;
    }

    private static Vector UninflectWords(String string, Connection connection, RamTrie ramTrie, int n) {
        Object object;
        String string2 = " \t-({[)}]_!@#%&*\\:;'\",.?/~+=|<>$`^";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        long l = 1L;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            try {
                Object object2;
                Object object3;
                Vector vector3 = DbUninflection.GetUninflections((String)object, connection);
                Vector<String> vector4 = new Vector<String>();
                int n2 = 0;
                while (n2 < vector3.size()) {
                    object3 = (InflectionRecord)vector3.elementAt(n2);
                    String string3 = ((InflectionRecord)object3).GetUninflectedTerm();
                    object2 = string3.toLowerCase();
                    if (!vector4.contains(object2)) {
                        vector4.addElement((String)object2);
                    }
                    ++n2;
                }
                if (vector3.size() == 0) {
                    object3 = ramTrie.GetUninflectedTermsByRules((String)object, 2047L, 0xFFFFFFL, true);
                    int n3 = 0;
                    while (n3 < ((Vector)object3).size()) {
                        object2 = (RuleResult)((Vector)object3).elementAt(n3);
                        String string4 = ((RuleResult)object2).GetOutTerm();
                        String string5 = string4.toLowerCase();
                        if (!vector4.contains(string5) && !DbInflection.IsExistInflectedTerm(string4, connection)) {
                            vector4.addElement(string5);
                        }
                        ++n3;
                    }
                }
                if ((l *= (long)vector4.size()) > (long)n) {
                    vector.removeAllElements();
                    vector.addElement(string);
                    return vector;
                }
                vector2.addElement(vector4);
            }
            catch (Exception exception) {
                break;
            }
        }
        vector = ToUninflectWords.FormCombinations(vector2);
        if (vector2.size() >= 1) {
            object = new LvgComparator();
            ((LvgComparator)object).SetLengthFlag(true);
            ((LvgComparator)object).SetCase(false);
            Collections.sort(vector, object);
        }
        return vector;
    }
}

