/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Inflection;

public class CatInfl {
    private long cat_ = 0L;
    private long infl_ = 0L;
    private static boolean[][] catInflRelation_ = new boolean[11][24];

    public CatInfl(long l, long l2) {
        this.cat_ = l;
        this.infl_ = l2;
    }

    public long GetCategory() {
        return this.cat_;
    }

    public long GetInflection() {
        return this.infl_;
    }

    public String GetCategoryStr() {
        String string = Category.ToName(this.cat_);
        return string;
    }

    public String GetInflectionStr() {
        String string = Inflection.ToName(this.infl_);
        return string;
    }

    public static CatInfl ConvertToBase(CatInfl catInfl) {
        long l = catInfl.GetCategory();
        long l2 = catInfl.GetInflection();
        if (l2 == Inflection.ToValue("singular") && l == Category.ToValue("noun")) {
            l2 = Inflection.ToValue("base");
        } else if (l2 == Inflection.ToValue("infinitive") && l == Category.ToValue("verb")) {
            l2 = Inflection.ToValue("base");
        } else if (l2 == Inflection.ToValue("positive") && l == Category.ToValue("adj")) {
            l2 = Inflection.ToValue("base");
        } else if (l2 == Inflection.ToValue("positive") && l == Category.ToValue("adv")) {
            l2 = Inflection.ToValue("base");
        }
        return new CatInfl(l, l2);
    }

    public static boolean IsRelated(long l, long l2) {
        int n = Category.GetBitIndex(l);
        int n2 = Inflection.GetBitIndex(l2);
        return catInflRelation_[n][n2];
    }

    static {
        int n = 0;
        while (n < 11) {
            CatInfl.catInflRelation_[n][0] = true;
            int n2 = 1;
            while (n2 < 24) {
                CatInfl.catInflRelation_[n][n2] = false;
                ++n2;
            }
            ++n;
        }
        CatInfl.catInflRelation_[0][1] = true;
        CatInfl.catInflRelation_[0][2] = true;
        CatInfl.catInflRelation_[0][8] = true;
        CatInfl.catInflRelation_[1][1] = true;
        CatInfl.catInflRelation_[1][2] = true;
        CatInfl.catInflRelation_[1][8] = true;
        CatInfl.catInflRelation_[2][4] = true;
        CatInfl.catInflRelation_[2][5] = true;
        CatInfl.catInflRelation_[2][6] = true;
        CatInfl.catInflRelation_[2][7] = true;
        CatInfl.catInflRelation_[2][10] = true;
        CatInfl.catInflRelation_[2][11] = true;
        CatInfl.catInflRelation_[2][12] = true;
        CatInfl.catInflRelation_[2][13] = true;
        CatInfl.catInflRelation_[2][14] = true;
        CatInfl.catInflRelation_[2][15] = true;
        CatInfl.catInflRelation_[2][16] = true;
        CatInfl.catInflRelation_[2][17] = true;
        CatInfl.catInflRelation_[2][18] = true;
        CatInfl.catInflRelation_[2][19] = true;
        CatInfl.catInflRelation_[2][20] = true;
        CatInfl.catInflRelation_[2][22] = true;
        CatInfl.catInflRelation_[6][5] = true;
        CatInfl.catInflRelation_[6][12] = true;
        CatInfl.catInflRelation_[6][21] = true;
        CatInfl.catInflRelation_[6][23] = true;
        CatInfl.catInflRelation_[7][3] = true;
        CatInfl.catInflRelation_[7][9] = true;
        CatInfl.catInflRelation_[10][4] = true;
        CatInfl.catInflRelation_[10][5] = true;
        CatInfl.catInflRelation_[10][6] = true;
        CatInfl.catInflRelation_[10][7] = true;
        CatInfl.catInflRelation_[10][10] = true;
        CatInfl.catInflRelation_[10][11] = true;
    }
}

