/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.BitMaskBase;
import gov.nih.nlm.nls.lvg.Util.Vec;
import java.util.Vector;

public class Category
extends BitMaskBase {
    public static final int ADJ_BIT = 0;
    public static final int ADV_BIT = 1;
    public static final int AUX_BIT = 2;
    public static final int COMPL_BIT = 3;
    public static final int CONJ_BIT = 4;
    public static final int DET_BIT = 5;
    public static final int MODAL_BIT = 6;
    public static final int NOUN_BIT = 7;
    public static final int PREP_BIT = 8;
    public static final int PRON_BIT = 9;
    public static final int VERB_BIT = 10;
    public static final int TOTAL_BITS = 11;
    public static final long ALL_BIT_VALUE = 2047L;
    public static final long NO_BIT_VALUE = 0L;
    private static Vector[] bitStr_ = new Vector[63];

    public Category() {
        super(2047L, bitStr_);
    }

    public Category(long l) {
        super(l, 2047L, bitStr_);
    }

    public static long ToValue(String string) {
        return BitMaskBase.ToValue(string, bitStr_);
    }

    public static String ToName(long l) {
        return BitMaskBase.ToName(l, 2047L, bitStr_);
    }

    public static String GetBitName(int n) {
        return Category.GetBitName(n, 0);
    }

    public static String GetBitName(int n, int n2) {
        return BitMaskBase.GetBitName(n, n2, bitStr_);
    }

    public static long Enumerate(String string) {
        return BitMaskBase.Enumerate(string, bitStr_);
    }

    public static Vector ToValues(long l) {
        return BitMaskBase.ToValues(l, 11);
    }

    public static long[] ToValuesArray(long l) {
        Vector vector = BitMaskBase.ToValues(l, 11);
        return Vec.ToArray(vector);
    }

    public static void main(String[] stringArray) {
        System.out.println("----- static methods -----");
        System.out.println(" -  ToValue(adv+adv+noun+verb): " + Category.ToValue("adv+adj+noun+verb"));
        System.out.println(" -  ToName(1155): " + Category.ToName(1155L));
        Vector vector = Category.ToValues(1155L);
        int n = 0;
        while (n < vector.size()) {
            System.out.println(" - Category.ToValues(1155): " + (Long)vector.elementAt(n));
            ++n;
        }
        long[] lArray = Category.ToValuesArray(1155L);
        int n2 = 0;
        while (n2 < lArray.length) {
            System.out.println(" - Category.ToValues(1155): " + lArray[n2]);
            ++n2;
        }
        System.out.println(" -  ToValue(noun): " + Category.ToValue("noun"));
        System.out.println(" -  GetBitValue(Category.NOUN_BIT): " + Category.GetBitValue(7));
        System.out.println("----- object methods -----");
        Category category = new Category(1155L);
        System.out.println(" - c1.GetValue(): " + category.GetValue());
        System.out.println(" - c1.GetName(): " + category.GetName());
        category.SetValue(2047L);
        System.out.println(" - c1.GetValue(): " + category.GetValue());
        System.out.println(" - c1.GetName(): " + category.GetName());
    }

    static {
        int n = 0;
        while (n < 63) {
            Category.bitStr_[n] = new Vector();
            ++n;
        }
        bitStr_[0].addElement("adj");
        bitStr_[0].addElement("adjective");
        bitStr_[0].addElement("ADJ");
        bitStr_[1].addElement("adv");
        bitStr_[1].addElement("adverb");
        bitStr_[1].addElement("ADV");
        bitStr_[2].addElement("aux");
        bitStr_[2].addElement("auxiliary");
        bitStr_[3].addElement("compl");
        bitStr_[3].addElement("complementizer");
        bitStr_[4].addElement("conj");
        bitStr_[4].addElement("conjunction");
        bitStr_[4].addElement("CON");
        bitStr_[4].addElement("con");
        bitStr_[5].addElement("det");
        bitStr_[5].addElement("determiner");
        bitStr_[5].addElement("DET");
        bitStr_[6].addElement("modal");
        bitStr_[7].addElement("noun");
        bitStr_[7].addElement("NOM");
        bitStr_[7].addElement("NPR");
        bitStr_[8].addElement("prep");
        bitStr_[8].addElement("preposition");
        bitStr_[8].addElement("PRE");
        bitStr_[8].addElement("pre");
        bitStr_[9].addElement("pron");
        bitStr_[9].addElement("pronoun");
        bitStr_[10].addElement("verb");
        bitStr_[10].addElement("VER");
        bitStr_[10].addElement("ver");
    }
}

