/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.LexItemComparator;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.util.Collections;
import java.util.Vector;

public class CombineRecords {
    public static final int BY_NONE = 0;
    public static final int BY_TERM = 1;
    public static final int BY_CATEGORY = 2;
    public static final int BY_INFLECTION = 3;
    public static final int BY_EUI = 4;

    public static Vector Combine(Vector vector, int n) {
        Vector vector2 = new Vector();
        if (n == 0) {
            vector2 = (Vector)vector.clone();
            return vector2;
        }
        Vector vector3 = new Vector(vector);
        LexItemComparator lexItemComparator = new LexItemComparator();
        lexItemComparator.SetRule(n);
        Collections.sort(vector3, lexItemComparator);
        int n2 = 0;
        while (n2 < vector3.size()) {
            if (n2 == 0) {
                LexItem lexItem = (LexItem)vector3.elementAt(n2);
                vector2.addElement(lexItem);
            } else {
                CombineRecords.CombineRecords(vector2, vector3, n2, n);
            }
            ++n2;
        }
        return vector2;
    }

    private static void CombineRecords(Vector vector, Vector vector2, int n, int n2) {
        LexItem lexItem;
        if (n == 0 || n >= vector2.size()) {
            return;
        }
        LexItem lexItem2 = (LexItem)vector.lastElement();
        if (!CombineRecords.IsCombinable(lexItem2, lexItem = (LexItem)vector2.elementAt(n), n2)) {
            vector.addElement(lexItem);
        } else {
            LexItem lexItem3 = CombineRecords.CombineByRule(lexItem2, lexItem, n2);
            vector.setElementAt(lexItem3, vector.size() - 1);
        }
    }

    private static LexItem CombineByRule(LexItem lexItem, LexItem lexItem2, int n) {
        LexItem lexItem3 = new LexItem(lexItem, true);
        long l = 0L;
        long l2 = 0L;
        switch (n) {
            case 1: {
                l = Bit.Add(lexItem.GetTargetCategory().GetValue(), lexItem2.GetTargetCategory().GetValue());
                l2 = Bit.Add(lexItem.GetTargetInflection().GetValue(), lexItem2.GetTargetInflection().GetValue());
                break;
            }
            case 4: {
                l = Bit.Add(lexItem.GetTargetCategory().GetValue(), lexItem2.GetTargetCategory().GetValue());
                l2 = Bit.Add(lexItem.GetTargetInflection().GetValue(), lexItem2.GetTargetInflection().GetValue());
                break;
            }
            case 2: {
                l = lexItem.GetTargetCategory().GetValue();
                l2 = Bit.Add(lexItem.GetTargetInflection().GetValue(), lexItem2.GetTargetInflection().GetValue());
                break;
            }
            case 3: {
                l = Bit.Add(lexItem.GetTargetCategory().GetValue(), lexItem2.GetTargetCategory().GetValue());
                l2 = lexItem.GetTargetInflection().GetValue();
            }
        }
        lexItem3.SetTargetCategory(l);
        lexItem3.SetTargetInflection(l2);
        return lexItem3;
    }

    private static boolean IsCombinable(LexItem lexItem, LexItem lexItem2, int n) {
        boolean bl = true;
        bl = bl && lexItem.GetOriginalTerm().equals(lexItem2.GetOriginalTerm()) && lexItem.GetFlowHistory().equals(lexItem2.GetFlowHistory());
        switch (n) {
            case 1: {
                bl = bl && lexItem.GetTargetTerm().equals(lexItem2.GetTargetTerm());
                break;
            }
            case 4: {
                bl = bl && lexItem.GetTargetTerm().equals(lexItem2.GetTargetTerm()) && lexItem.GetMutateInformation().equals(lexItem2.GetMutateInformation());
                break;
            }
            case 2: {
                bl = bl && lexItem.GetTargetTerm().equals(lexItem2.GetTargetTerm()) && lexItem.GetTargetCategory().GetValue() == lexItem2.GetTargetCategory().GetValue();
                break;
            }
            case 3: {
                bl = bl && lexItem.GetTargetTerm().equals(lexItem2.GetTargetTerm()) && lexItem.GetTargetInflection().GetValue() == lexItem2.GetTargetInflection().GetValue();
            }
        }
        return bl;
    }
}

