/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.LvgComparator;
import java.util.Comparator;

public class LexItemComparator
implements Comparator {
    public static final int NONE = 0;
    public static final int TERM = 1;
    public static final int TERM_CAT = 2;
    public static final int TERM_CAT_INFL = 3;
    public static final int LVG_RULE = 10;
    public static final int ALPHABETIC = 11;
    private int rule_ = 0;
    private boolean caseFlag_ = true;
    private LvgComparator lc_ = new LvgComparator();
    private static int[] catPriority_ = new int[11];

    public int compare(Object object, Object object2) {
        int n = 0;
        switch (this.rule_) {
            case 1: 
            case 11: {
                n = this.CompareByAlphaBetic(object, object2);
                break;
            }
            case 2: {
                n = this.CompareByTermCat(object, object2);
                break;
            }
            case 3: {
                n = this.CompareByTermCatInfl(object, object2);
                break;
            }
            case 10: {
                n = this.CompareByLvg(object, object2);
                break;
            }
            default: {
                n = this.CompareForCombine(object, object2);
            }
        }
        return n;
    }

    public void SetRule(int n) {
        this.rule_ = n;
    }

    public void SetCase(boolean bl) {
        this.caseFlag_ = bl;
    }

    public static int GetCategoryPreority(long l) {
        int n = 12;
        int n2 = Category.GetBitIndex(l);
        if (n2 > 0) {
            n = catPriority_[n2];
        }
        return n;
    }

    private int CompareByAlphaBetic(Object object, Object object2) {
        LexItem lexItem = (LexItem)object;
        LexItem lexItem2 = (LexItem)object2;
        this.lc_.SetLengthFlag(false);
        this.lc_.SetCase(this.caseFlag_);
        int n = this.lc_.compare(lexItem.GetTargetTerm(), lexItem2.GetTargetTerm());
        return n;
    }

    private int CompareByTermCat(Object object, Object object2) {
        LexItem lexItem = (LexItem)object;
        LexItem lexItem2 = (LexItem)object2;
        this.lc_.SetLengthFlag(false);
        this.lc_.SetCase(this.caseFlag_);
        int n = this.lc_.compare(lexItem.GetTargetTerm(), lexItem2.GetTargetTerm());
        if (n == 0) {
            n = (int)(lexItem.GetTargetCategory().GetValue() - lexItem2.GetTargetCategory().GetValue());
        }
        return n;
    }

    private int CompareByTermCatInfl(Object object, Object object2) {
        LexItem lexItem = (LexItem)object;
        LexItem lexItem2 = (LexItem)object2;
        this.lc_.SetLengthFlag(false);
        this.lc_.SetCase(this.caseFlag_);
        int n = this.lc_.compare(lexItem.GetTargetTerm(), lexItem2.GetTargetTerm());
        if (n == 0 && (n = (int)(lexItem.GetTargetCategory().GetValue() - lexItem2.GetTargetCategory().GetValue())) == 0) {
            long l = lexItem.GetTargetInflection().GetValue() - lexItem2.GetTargetInflection().GetValue();
            n = l > 0L ? 1 : (l < 0L ? -1 : 0);
        }
        return n;
    }

    private int CompareByLvg(Object object, Object object2) {
        int n;
        LexItem lexItem = (LexItem)object;
        LexItem lexItem2 = (LexItem)object2;
        int n2 = LexItemComparator.GetCategoryPreority(lexItem.GetTargetCategory().GetValue());
        if (n2 != (n = LexItemComparator.GetCategoryPreority(lexItem2.GetTargetCategory().GetValue()))) {
            return n2 - n;
        }
        this.lc_.SetLengthFlag(true);
        this.lc_.SetCase(false);
        int n3 = this.lc_.compare(lexItem.GetTargetTerm(), lexItem2.GetTargetTerm());
        return n3;
    }

    private int CompareForCombine(Object object, Object object2) {
        LexItem lexItem = (LexItem)object;
        LexItem lexItem2 = (LexItem)object2;
        int n = -1;
        if (this.rule_ == 0) {
            return n;
        }
        this.lc_.SetLengthFlag(true);
        this.lc_.SetCase(this.caseFlag_);
        n = this.lc_.compare(lexItem.GetTargetTerm(), lexItem2.GetTargetTerm());
        if (n == 0) {
            switch (this.rule_) {
                case 4: {
                    n = this.lc_.compare(lexItem.GetMutateInformation(), lexItem2.GetMutateInformation());
                    break;
                }
                case 2: {
                    int n2 = LexItemComparator.GetCategoryPreority(lexItem.GetTargetCategory().GetValue());
                    int n3 = LexItemComparator.GetCategoryPreority(lexItem2.GetTargetCategory().GetValue());
                    n = n2 - n3;
                    break;
                }
                case 3: {
                    n = this.lc_.compare(String.valueOf(lexItem.GetTargetInflection().GetValue()), String.valueOf(lexItem2.GetTargetInflection().GetValue()));
                }
            }
        }
        return n;
    }

    static {
        LexItemComparator.catPriority_[7] = 1;
        LexItemComparator.catPriority_[0] = 2;
        LexItemComparator.catPriority_[10] = 3;
        LexItemComparator.catPriority_[1] = 4;
        LexItemComparator.catPriority_[8] = 5;
        LexItemComparator.catPriority_[9] = 6;
        LexItemComparator.catPriority_[4] = 7;
        LexItemComparator.catPriority_[5] = 8;
        LexItemComparator.catPriority_[6] = 9;
        LexItemComparator.catPriority_[2] = 10;
        LexItemComparator.catPriority_[3] = 11;
    }
}

