/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Trie.RuleException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class InflectionRule {
    private String ruleStr_ = null;
    private String inSuffix_ = null;
    private String outSuffix_ = null;
    private long inCategory_ = 0L;
    private long outCategory_ = 0L;
    private long inInflection_ = 0L;
    private long outInflection_ = 0L;
    private Hashtable exceptions_ = null;

    public InflectionRule(String string) {
        this.ruleStr_ = string;
        this.DecomposeRuleStr();
    }

    public void Reverse() {
        String string = this.inSuffix_;
        long l = this.inCategory_;
        long l2 = this.inInflection_;
        this.inSuffix_ = this.outSuffix_;
        this.inCategory_ = this.outCategory_;
        this.inInflection_ = this.outInflection_;
        this.outSuffix_ = string;
        this.outCategory_ = l;
        this.outInflection_ = l2;
        String string2 = new Character('|').toString();
        this.ruleStr_ = this.inSuffix_ + string2 + Category.ToName(this.inCategory_) + string2 + Inflection.ToName(this.inInflection_) + string2 + this.outSuffix_ + string2 + Category.ToName(this.outCategory_) + string2 + Inflection.ToName(this.outInflection_);
    }

    public boolean equals(InflectionRule inflectionRule) {
        return this.ruleStr_.equals(inflectionRule.GetRuleStr());
    }

    public String GetInSuffix() {
        return this.inSuffix_;
    }

    public String GetOutSuffix() {
        return this.outSuffix_;
    }

    public Hashtable GetExceptions() {
        return this.exceptions_;
    }

    public String GetRuleStr() {
        return this.ruleStr_;
    }

    public long GetInCategory() {
        return this.inCategory_;
    }

    public String GetInCategoryStr() {
        return Category.ToName(this.inCategory_);
    }

    public long GetInInflection() {
        return this.inInflection_;
    }

    public String GetInInflectionStr() {
        return Inflection.ToName(this.inInflection_);
    }

    public long GetOutCategory() {
        return this.outCategory_;
    }

    public String GetOutCategoryStr() {
        return Category.ToName(this.outCategory_);
    }

    public long GetOutInflection() {
        return this.outInflection_;
    }

    public String GetOutInflectionStr() {
        return Inflection.ToName(this.outInflection_);
    }

    public void AddException(String string) {
        RuleException ruleException = new RuleException(string);
        if (!ruleException.IsLegalFormat()) {
            return;
        }
        if (this.exceptions_ == null) {
            this.exceptions_ = new Hashtable();
        }
        String string2 = ruleException.GetKey();
        String string3 = ruleException.GetValue();
        Enumeration enumeration = this.exceptions_.keys();
        Enumeration enumeration2 = this.exceptions_.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            if (!string2.equals(enumeration.nextElement()) || !string3.equals(enumeration2.nextElement())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.exceptions_.put(string2, string3);
        }
    }

    public static void main(String[] stringArray) {
        InflectionRule inflectionRule = new InflectionRule("Cy$|adv|positive|Cier$|adv|comparative");
        inflectionRule.AddException("|er;");
        inflectionRule.AddException("inhal|inhaler;");
        inflectionRule.PrintRule();
        inflectionRule.Reverse();
        inflectionRule.PrintRule();
    }

    private void DecomposeRuleStr() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.ruleStr_, "|");
        this.inSuffix_ = stringTokenizer.nextToken();
        this.inCategory_ = Category.ToValue(stringTokenizer.nextToken());
        this.inInflection_ = Inflection.ToValue(stringTokenizer.nextToken());
        this.outSuffix_ = stringTokenizer.nextToken();
        this.outCategory_ = Category.ToValue(stringTokenizer.nextToken());
        this.outInflection_ = Inflection.ToValue(stringTokenizer.nextToken());
    }

    private void PrintRule() {
        System.out.println("------ Inflection Rule ------");
        System.out.println("ruleStr_: " + this.ruleStr_);
        System.out.println("inSuffix_: " + this.inSuffix_);
        System.out.println("inCategory_: " + this.inCategory_);
        System.out.println("inInflection_: " + this.inInflection_);
        System.out.println("outSuffix_: " + this.outSuffix_);
        System.out.println("outCategory_: " + this.outCategory_);
        System.out.println("outInflection_: " + this.outInflection_);
        System.out.println("exceptions_: " + (this.exceptions_ == null ? 0 : this.exceptions_.size()));
    }
}

