/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Trie.PersistentExceptionNode;
import gov.nih.nlm.nls.lvg.Trie.PersistentList;
import gov.nih.nlm.nls.lvg.Trie.PersistentListNode;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PersistentRuleNode
extends PersistentListNode {
    private String ruleStr_ = null;
    private long exceptionAddress_ = -1L;

    public PersistentRuleNode(long l) {
        super(l);
    }

    public PersistentRuleNode(long l, long l2) {
        super(l, l2);
    }

    public PersistentRuleNode(String string, long l) {
        this.ruleStr_ = string;
        this.exceptionAddress_ = l;
    }

    public String GetRuleString() {
        return this.ruleStr_;
    }

    public long GetExceptionAddress() {
        return this.exceptionAddress_;
    }

    public void WriteData(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeUTF(this.ruleStr_);
        randomAccessFile.writeLong(this.exceptionAddress_);
    }

    public void ReadData(RandomAccessFile randomAccessFile) throws IOException {
        this.ruleStr_ = randomAccessFile.readUTF();
        this.exceptionAddress_ = randomAccessFile.readLong();
    }

    public static PersistentListNode GetNode(RandomAccessFile randomAccessFile, long l) throws IOException {
        PersistentRuleNode persistentRuleNode = new PersistentRuleNode(l);
        randomAccessFile.seek(l);
        persistentRuleNode.ReadData(randomAccessFile);
        long l2 = randomAccessFile.readLong();
        persistentRuleNode.SetNext(l2);
        return persistentRuleNode;
    }

    public static void PrintList(String string, String string2, long l) throws IOException {
        PersistentList persistentList = new PersistentList(string);
        RandomAccessFile randomAccessFile = persistentList.GetRaf();
        long l2 = l + 12L;
        randomAccessFile.seek(l2);
        int n = 0;
        while (l2 != -1L) {
            PersistentRuleNode persistentRuleNode = (PersistentRuleNode)PersistentRuleNode.GetNode(randomAccessFile, l2);
            long l3 = persistentRuleNode.GetExceptionAddress();
            System.out.println("    R-" + n + ": '" + persistentRuleNode.GetRuleString() + "': " + l3);
            l2 = persistentRuleNode.GetNext();
            ++n;
            if (l3 == -1L) continue;
            PersistentExceptionNode.PrintList(string2, l3);
        }
        persistentList.Close();
    }
}

