/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Trie.PersistentRuleNode;
import gov.nih.nlm.nls.lvg.Trie.PersistentTreeNode;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PersistentTrieNode
extends PersistentTreeNode {
    private char key_ = (char)32;
    private long ruleAddress_ = -1L;

    public PersistentTrieNode(long l) {
        super(l);
    }

    public PersistentTrieNode(char c, long l) {
        this.key_ = c;
        this.ruleAddress_ = l;
    }

    public PersistentTrieNode(int n, long l, long l2, long l3, long l4) {
        super(n, l, l2, l3, l4);
    }

    public char GetKey() {
        return this.key_;
    }

    public long GetRuleAddress() {
        return this.ruleAddress_;
    }

    public void WriteData(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeChar(this.key_);
        randomAccessFile.writeLong(this.ruleAddress_);
    }

    public void ReadData(RandomAccessFile randomAccessFile) throws IOException {
        this.key_ = randomAccessFile.readChar();
        this.ruleAddress_ = randomAccessFile.readLong();
    }

    public static PersistentTreeNode GetNode(RandomAccessFile randomAccessFile, long l) throws IOException {
        PersistentTrieNode persistentTrieNode = new PersistentTrieNode(l);
        randomAccessFile.seek(l);
        int n = randomAccessFile.readInt();
        long l2 = randomAccessFile.readLong();
        long l3 = randomAccessFile.readLong();
        long l4 = randomAccessFile.readLong();
        persistentTrieNode.ReadData(randomAccessFile);
        persistentTrieNode.SetLevel(n);
        persistentTrieNode.SetParent(l3);
        persistentTrieNode.SetNext(l2);
        persistentTrieNode.SetChild(l4);
        return persistentTrieNode;
    }

    public static int PrintNode(RandomAccessFile randomAccessFile, long l, String string, String string2) throws IOException {
        int n = 0;
        PersistentTrieNode persistentTrieNode = (PersistentTrieNode)PersistentTrieNode.GetNode(randomAccessFile, l);
        System.out.print("--");
        int n2 = 0;
        while (n2 < persistentTrieNode.GetLevel()) {
            System.out.print("---");
            ++n2;
        }
        long l2 = persistentTrieNode.GetRuleAddress();
        System.out.print(" (" + persistentTrieNode.GetKey() + "@ " + l + ", Rule @: " + l2 + ")");
        System.out.print(System.getProperty("line.separator").toString());
        ++n;
        if (l2 != -1L) {
            PersistentRuleNode.PrintList(string, string2, l2);
        }
        long l3 = persistentTrieNode.GetChild();
        while (l3 != -1L) {
            PersistentTreeNode persistentTreeNode = PersistentTrieNode.GetNode(randomAccessFile, l3);
            n += PersistentTrieNode.PrintNode(randomAccessFile, l3, string, string2);
            l3 = persistentTreeNode.GetNext();
        }
        return n;
    }
}

