/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Trie.InflectionRule;
import gov.nih.nlm.nls.lvg.Trie.PersistentExceptionNode;
import gov.nih.nlm.nls.lvg.Trie.PersistentList;
import gov.nih.nlm.nls.lvg.Trie.PersistentListNode;
import gov.nih.nlm.nls.lvg.Trie.PersistentRuleNode;
import gov.nih.nlm.nls.lvg.Trie.PersistentTree;
import gov.nih.nlm.nls.lvg.Trie.PersistentTrieNode;
import gov.nih.nlm.nls.lvg.Trie.TrieNode;
import gov.nih.nlm.nls.lvg.Trie.TrieTree;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class PersistentTrieTree {
    private String triePath_ = null;
    private String rulePath_ = null;
    private String exceptionPath_ = null;
    private PersistentTree persistentTrie_ = null;

    public PersistentTrieTree(String string, String string2, String string3) {
        this.triePath_ = string;
        this.rulePath_ = string2;
        this.exceptionPath_ = string3;
        this.persistentTrie_ = new PersistentTree(this.triePath_);
    }

    public void BuildPersistentTrieTree(boolean bl) throws IOException {
        TrieTree trieTree = new TrieTree(true);
        if (bl) {
            trieTree.LoadRulesFromFile("../../data/rules/", "im.rul", false, true);
            trieTree.LoadRulesFromFile("../../data/rules/", "im.rul", true, false);
        } else {
            trieTree.LoadRulesFromFile("../../data/rules/", "dm.rul", false, true);
            trieTree.LoadRulesFromFile("../../data/rules/", "dm.rul", true, false);
        }
        TrieNode trieNode = trieTree.GetRoot();
        long l = -1L;
        this.Insert(trieNode, l);
    }

    public void PrintPersistentTrieTree() throws IOException {
        int n = 0;
        n = PersistentTrieNode.PrintNode(this.persistentTrie_.GetRaf(), this.persistentTrie_.GetRootAddress(), this.rulePath_, this.exceptionPath_);
        System.out.println("------------------------------------");
        System.out.println("-- Number of Node: " + n);
    }

    public void Close() throws IOException {
        this.persistentTrie_.Close();
    }

    public static void main(String[] stringArray) {
        PersistentTrieTree persistentTrieTree = new PersistentTrieTree("trie.data", "rule.data", "exception.data");
        boolean bl = false;
        if (stringArray.length != 1) {
            System.out.println("Usage: java PersistentTrieTree <-i/d>");
            System.out.println("   -i: build persistent file for inflection");
        } else if (stringArray[0].equals("-i")) {
            bl = true;
        }
        try {
            persistentTrieTree.BuildPersistentTrieTree(bl);
            persistentTrieTree.PrintPersistentTrieTree();
            persistentTrieTree.Close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    private void Insert(TrieNode trieNode, long l) throws IOException {
        Object object;
        long l2 = -1L;
        Vector vector = trieNode.GetRules();
        if (vector != null) {
            PersistentList persistentList = new PersistentList(this.rulePath_);
            int n = 0;
            while (n < vector.size()) {
                Object object2;
                InflectionRule inflectionRule = (InflectionRule)vector.elementAt(n);
                object = inflectionRule.GetExceptions();
                long l3 = -1L;
                boolean bl = true;
                if (object != null) {
                    object2 = new PersistentList(this.exceptionPath_);
                    Enumeration enumeration = ((Hashtable)object).keys();
                    Enumeration enumeration2 = ((Hashtable)object).elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String string2 = (String)enumeration2.nextElement();
                        PersistentExceptionNode persistentExceptionNode = new PersistentExceptionNode(string, string2);
                        ((PersistentList)object2).Add(persistentExceptionNode);
                        if (!bl) continue;
                        bl = false;
                        l3 = persistentExceptionNode.GetAddress() - 12L;
                    }
                    ((PersistentList)object2).Close();
                }
                object2 = new PersistentRuleNode(inflectionRule.GetRuleStr(), l3);
                persistentList.Add((PersistentListNode)object2);
                if (n == 0) {
                    l2 = ((PersistentListNode)object2).GetAddress() - 12L;
                }
                ++n;
            }
            persistentList.Close();
        }
        char c = trieNode.GetKey();
        PersistentTrieNode persistentTrieNode = new PersistentTrieNode(c, l2);
        this.persistentTrie_.Add(persistentTrieNode, l);
        if (trieNode.GetChild() != null) {
            l = persistentTrieNode.GetAddress();
            int n = 0;
            while (n < trieNode.GetChild().size()) {
                object = (TrieNode)trieNode.GetChild().elementAt(n);
                this.Insert((TrieNode)object, l);
                ++n;
            }
        }
    }
}

