/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Lib.CatInfl;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Trie.InflectionRule;
import gov.nih.nlm.nls.lvg.Trie.PersistentTrie;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import gov.nih.nlm.nls.lvg.Trie.RuleResultComparator;
import gov.nih.nlm.nls.lvg.Trie.TrieNode;
import gov.nih.nlm.nls.lvg.Trie.TrieTree;
import gov.nih.nlm.nls.lvg.Trie.WildCard;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;

public final class RamTrie {
    private TrieTree trie_ = new TrieTree(true);
    private int minTermLength_ = 2;
    private int matchedNodeNum_ = 0;
    private int minTrieStemLength_ = 0;
    private boolean isInflection_ = true;

    public RamTrie(boolean bl, int n, String string, int n2) {
        this.isInflection_ = bl;
        this.minTermLength_ = n;
        this.minTrieStemLength_ = n2;
        String string2 = string + "/data/rules/";
        String string3 = "im.rul";
        if (!bl) {
            string3 = "dm.rul";
        }
        this.trie_.LoadRulesFromFile(string2, string3, false, true);
        this.trie_.LoadRulesFromFile(string2, string3, true, false);
    }

    private Vector Mutate(String string, boolean bl, long l, long l2, long l3, long l4) {
        Object object;
        Object object2;
        Vector<RuleResult> vector = new Vector<RuleResult>();
        Vector vector2 = this.trie_.FindRule(string);
        this.matchedNodeNum_ = vector2.size();
        int n = 0;
        int n2 = 0;
        while (n2 < this.matchedNodeNum_) {
            object2 = (TrieNode)vector2.elementAt(n2);
            Vector vector3 = ((TrieNode)object2).GetRules();
            if (object2 == null || vector3 == null) {
                System.out.println("** Error: null in TrieNode or it's rules");
                break;
            }
            int n3 = 0;
            while (n3 < vector3.size()) {
                RuleResult ruleResult;
                object = (InflectionRule)vector3.elementAt(n3);
                if ((this.isInflection_ || this.minTrieStemLength_ <= 0 || this.GetStemLength(string, (InflectionRule)object) > this.minTrieStemLength_) && !this.IsException(string, (InflectionRule)object) && (ruleResult = this.ApplyRules(string, (InflectionRule)object, l, l2, l3, l4)) != null) {
                    if (bl) {
                        vector.add(ruleResult);
                    } else if (((TrieNode)object2).GetLevel() > n) {
                        n = ((TrieNode)object2).GetLevel();
                        vector.removeAllElements();
                        vector.add(ruleResult);
                    } else if (((TrieNode)object2).GetLevel() == n) {
                        vector.add(ruleResult);
                    }
                }
                ++n3;
            }
            ++n2;
        }
        if (!this.isInflection_) {
            return vector;
        }
        object2 = new Vector();
        int n4 = 0;
        while (n4 < vector.size()) {
            RuleResult ruleResult = (RuleResult)vector.elementAt(n4);
            object = ruleResult.GetOutTerm();
            if (((String)object).length() > this.minTermLength_ || ((String)object).equals(string)) {
                ((Vector)object2).addElement(ruleResult);
            }
            ++n4;
        }
        return object2;
    }

    public Vector GetUninflectedTermsByRules(String string, long l, long l2, boolean bl) {
        Vector vector = this.Mutate(string, bl, l, l2, 1155L, 1793L);
        RuleResultComparator ruleResultComparator = new RuleResultComparator();
        return vector;
    }

    public CatInfl GetCatInflByRules(String string, long l, long l2) {
        Object object;
        Vector vector = new Vector();
        long l3 = 0L;
        long l4 = 0L;
        Vector vector2 = this.trie_.FindRule(string);
        this.matchedNodeNum_ = vector2.size();
        boolean bl = false;
        int n = 0;
        while (n < vector2.size()) {
            object = (TrieNode)vector2.elementAt(n);
            Vector vector3 = ((TrieNode)object).GetRules();
            if (object == null || vector3 == null) {
                System.out.println("** Error: null in TrieNode or it's rules");
                break;
            }
            int n2 = 0;
            while (n2 < vector3.size()) {
                InflectionRule inflectionRule = (InflectionRule)vector3.elementAt(n2);
                if (!this.IsException(string, inflectionRule)) {
                    long l5 = inflectionRule.GetInCategory();
                    long l6 = inflectionRule.GetInInflection();
                    if (Bit.Contain(l, l5) && Bit.Contain(l2, l6)) {
                        l3 |= l5;
                        l4 |= l6;
                    }
                }
                ++n2;
            }
            ++n;
        }
        object = new CatInfl(l3, l4);
        return object;
    }

    public Vector GetCatInflsByRules(String string, long l, long l2) {
        long l3 = 0L;
        long l4 = 0L;
        Vector<CatInfl> vector = new Vector<CatInfl>();
        Vector vector2 = this.trie_.FindRule(string);
        this.matchedNodeNum_ = vector2.size();
        boolean bl = false;
        int n = 0;
        while (n < vector2.size()) {
            TrieNode trieNode = (TrieNode)vector2.elementAt(n);
            Vector vector3 = trieNode.GetRules();
            if (trieNode == null || vector3 == null) {
                System.out.println("** Error: null in TrieNode or it's rules");
                break;
            }
            int n2 = 0;
            while (n2 < vector3.size()) {
                InflectionRule inflectionRule = (InflectionRule)vector3.elementAt(n2);
                if (!this.IsException(string, inflectionRule)) {
                    long l5 = inflectionRule.GetInCategory();
                    long l6 = inflectionRule.GetInInflection();
                    CatInfl catInfl = new CatInfl(l5, l6);
                    vector.addElement(catInfl);
                }
                ++n2;
            }
            ++n;
        }
        return vector;
    }

    public Vector GetInflectedTermsByRules(String string, long l, long l2, boolean bl) {
        Object object;
        Vector vector = this.Mutate(string, bl, l, l2, 1155L, 1793L);
        Vector vector2 = new Vector();
        String string2 = null;
        long l3 = -1L;
        int n = 0;
        while (n < vector.size()) {
            object = (RuleResult)vector.elementAt(n);
            String string3 = ((RuleResult)object).GetOutTerm();
            String string4 = ((RuleResult)object).GetRuleString();
            long l4 = Category.ToValue(((RuleResult)object).GetOutCategory());
            Vector vector3 = new Vector();
            if (l4 != l3 || !string3.equals(string2)) {
                vector3 = this.Mutate(string3, bl, l4, 2099071L, 1155L, 2099071L);
            }
            string2 = string3;
            l3 = l4;
            Vector vector4 = this.RemoveIllegalTerms(string3, vector3);
            vector2 = PersistentTrie.AddRusultsToInflectList(vector2, vector4);
            ++n;
        }
        object = new RuleResultComparator();
        Collections.sort(vector2, object);
        return vector2;
    }

    public Vector GetDerivationsByRules(String string, long l, long l2, boolean bl) {
        Vector vector = this.Mutate(string, bl, l, l2, 1155L, 1793L);
        return vector;
    }

    public void PrintResults(Vector vector) {
        System.out.println("-- matchNodeList size: " + this.GetMatchedNodeNum());
        int n = 0;
        while (n < vector.size()) {
            RuleResult ruleResult = (RuleResult)vector.elementAt(n);
            System.out.println(ruleResult.GetInTerm() + " --> " + ruleResult.GetOutTerm() + " ... Rule: " + ruleResult.GetRuleString());
            ++n;
        }
    }

    public TrieTree GetTrie() {
        return this.trie_;
    }

    public int GetMatchedNodeNum() {
        return this.matchedNodeNum_;
    }

    public void SetMinTermLength(int n) {
        this.minTermLength_ = n;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.out.println("Usage: java RamTrie <term> <-i/d> <-ps>");
            System.out.println(" term: input term for testing");
            System.out.println("   -i: mutate with all branch rules applied");
            System.out.println("   -p: print details, rule, & exceptions");
            System.out.println("   -s: mutate with all branch rules applied");
        } else {
            String string = stringArray[0];
            Configuration configuration = new Configuration("data.config.lvg", true);
            String string2 = configuration.GetConfiguration("LVG_DIR") + "/data/rules/";
            boolean bl = true;
            if (stringArray[1].equals("-d")) {
                bl = false;
            }
            boolean bl2 = false;
            if (stringArray[2].equals("-s")) {
                bl2 = true;
            }
            int n = Integer.parseInt(configuration.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
            RamTrie ramTrie = new RamTrie(bl, 3, string2, n);
            if (bl) {
                System.out.println("-------- Uninflected Terms ----------");
                Vector vector = ramTrie.GetUninflectedTermsByRules(string, 2047L, 0xFFFFFFL, true);
                ramTrie.PrintResults(vector);
                System.out.println("-------- Inflected Terms ------------");
                vector = ramTrie.GetInflectedTermsByRules(string, 2047L, 0xFFFFFFL, true);
                ramTrie.PrintResults(vector);
                System.out.println("------ Category & Inflection -----");
                CatInfl catInfl = ramTrie.GetCatInflByRules(string, 2047L, 0xFFFFFFL);
                System.out.println(catInfl.GetCategory() + ", " + catInfl.GetInflection());
                System.out.println("------ Categories & Inflections -----");
                vector = ramTrie.GetCatInflsByRules(string, 2047L, 0xFFFFFFL);
                int n2 = 0;
                while (n2 < vector.size()) {
                    catInfl = (CatInfl)vector.elementAt(n2);
                    System.out.println(catInfl.GetCategory() + ", " + catInfl.GetInflection());
                    ++n2;
                }
            } else {
                System.out.println("---------- Derivations -------------");
                Vector vector = ramTrie.GetDerivationsByRules(string, 2047L, 0xFFFFFFL, true);
                ramTrie.PrintResults(vector);
            }
        }
    }

    private Vector RemoveIllegalTerms(String string, Vector vector) {
        Vector<RuleResult> vector2 = new Vector<RuleResult>();
        int n = 0;
        while (n < vector.size()) {
            RuleResult ruleResult = (RuleResult)vector.elementAt(n);
            String string2 = ruleResult.GetOutTerm();
            String string3 = ruleResult.GetRuleString();
            long l = Inflection.ToValue(ruleResult.GetOutInflection());
            if (!Inflection.Contains(1793L, l) || string.equals(string2)) {
                vector2.addElement(ruleResult);
            }
            ++n;
        }
        return vector2;
    }

    private boolean IsException(String string, InflectionRule inflectionRule) {
        boolean bl = false;
        Hashtable hashtable = inflectionRule.GetExceptions();
        if (hashtable != null) {
            bl = hashtable.containsKey(string);
        }
        return bl;
    }

    private int GetStemLength(String string, InflectionRule inflectionRule) {
        int n = string.length() + 1 - inflectionRule.GetInSuffix().length();
        return n;
    }

    private RuleResult ApplyRules(String string, InflectionRule inflectionRule, long l, long l2, long l3, long l4) {
        String string2 = string + '$';
        String string3 = inflectionRule.GetInSuffix();
        String string4 = inflectionRule.GetOutSuffix();
        int n = string2.length();
        int n2 = string3.length();
        long l5 = inflectionRule.GetInCategory();
        long l6 = inflectionRule.GetOutCategory();
        long l7 = inflectionRule.GetInInflection();
        long l8 = inflectionRule.GetOutInflection();
        String string5 = string2.substring(0, n - n2);
        String string6 = WildCard.GetSuffix(string3, string4, string2);
        String string7 = string5 + string6;
        string7 = string7.substring(0, string7.length() - 1);
        RuleResult ruleResult = null;
        if (Category.Contains(l, l5) && Category.Contains(l3, l6) && Inflection.Contains(l2, l7) && Inflection.Contains(l4, l8)) {
            ruleResult = new RuleResult(string, string7, inflectionRule.GetRuleStr());
        }
        return ruleResult;
    }
}

