/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import java.util.StringTokenizer;

public class RuleException {
    private String exceptionStr_ = null;
    private String key_ = null;
    private String value_ = null;
    private boolean legalFormat_ = true;

    public RuleException(String string) {
        this.exceptionStr_ = string.trim();
        this.DecomposeExceptionStr();
    }

    public void Reverse() {
        String string = this.key_;
        this.key_ = this.value_;
        this.value_ = string;
        this.exceptionStr_ = this.key_ + "|" + this.value_ + ";";
    }

    public boolean equals(RuleException ruleException) {
        return this.exceptionStr_.equals(ruleException.GetExceptionStr());
    }

    public String GetKey() {
        return this.key_;
    }

    public String GetValue() {
        return this.value_;
    }

    public String GetExceptionStr() {
        return this.exceptionStr_;
    }

    public boolean IsLegalFormat() {
        return this.legalFormat_;
    }

    public static void main(String[] stringArray) {
        String string = "  key|value";
        RuleException ruleException = new RuleException(string);
        ruleException.PrintException();
        ruleException.Reverse();
        ruleException.PrintException();
        string = "|value;";
        ruleException = new RuleException(string);
        ruleException.PrintException();
        ruleException.Reverse();
        ruleException.PrintException();
        string = "key|;";
        ruleException = new RuleException(string);
        ruleException.PrintException();
        ruleException.Reverse();
        ruleException.PrintException();
        string = "|;";
        ruleException = new RuleException(string);
        ruleException.PrintException();
        ruleException.Reverse();
        ruleException.PrintException();
    }

    private void DecomposeExceptionStr() {
        if (this.exceptionStr_ == null || this.exceptionStr_.indexOf(124) == -1 || !this.exceptionStr_.endsWith(";") || this.exceptionStr_.indexOf(32) != -1) {
            System.out.println("** Error: Wrong format in RuleException(" + this.exceptionStr_ + ")");
            this.legalFormat_ = false;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.exceptionStr_, "|;");
        if (this.exceptionStr_.equals("|;")) {
            this.key_ = "";
            this.value_ = "";
        } else if (this.exceptionStr_.startsWith("|")) {
            this.key_ = "";
            this.value_ = stringTokenizer.nextToken();
        } else if (this.exceptionStr_.endsWith("|;")) {
            this.key_ = stringTokenizer.nextToken();
            this.value_ = "";
        } else {
            this.key_ = stringTokenizer.nextToken();
            this.value_ = stringTokenizer.nextToken();
        }
    }

    private void PrintException() {
        System.out.println("------ Rule Exception ------");
        System.out.println("exceptionStr_: " + this.exceptionStr_);
        System.out.println("key_: " + this.key_);
        System.out.println("value_: " + this.value_);
    }
}

