/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Util;

import gov.nih.nlm.nls.lvg.Util.Char;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;

public class Word {
    private static final String catelogSeparators_ = ".-/";

    public static boolean IsCatelogNumber(String string) {
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, catelogSeparators_);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (Word.IsDigitWord(string2)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean IsDate(String string) {
        boolean bl = Word.IsDate(string, "d/M/yy") || Word.IsDate(string, "d.M.yy") || Word.IsDate(string, "d-M-yy");
        return bl;
    }

    public static boolean IsFloat(String string) {
        boolean bl = false;
        try {
            Float.parseFloat(string);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public static boolean HasPunctuation(String string) {
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            if (Char.IsPunctuation(string.charAt(n))) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("** Usage: java Word <inStr>");
        } else {
            String string = stringArray[0];
            System.out.println("-- inStr: " + string);
            System.out.println("-- HasPunctuation: " + Word.HasPunctuation(string));
            System.out.println("-- IsCatelog: " + Word.IsCatelogNumber(string));
            System.out.println("-- IsFloat: " + Word.IsFloat(string));
            System.out.println("-- IsDate: " + Word.IsDate(string));
        }
    }

    private static boolean IsDate(String string, String string2) {
        boolean bl = false;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            simpleDateFormat.parse(string);
            bl = true;
        }
        catch (ParseException parseException) {
            bl = false;
        }
        return bl;
    }

    private static boolean IsDigitWord(String string) {
        boolean bl = true;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isDigit(c)) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }
}

