/*
 * Decompiled with CFR 0.152.
 */
import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.SystemOption;
import gov.nih.nlm.nls.lvg.Flows.ToTokenize;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.In;
import gov.nih.nlm.nls.lvg.Util.Out;
import gov.nih.nlm.nls.lvg.Util.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Vector;

public class wordInd
extends SystemOption {
    private static final String NO_OUTPUT_STR = "-No Output-";
    private static boolean runFlag_ = true;
    private static boolean noOutputFlag_ = false;
    private static boolean promptFlag_ = false;
    private static boolean reserveCaseFlag_ = false;
    private static String separator_ = GlobalBehavior.GetFieldSeparator();
    private static BufferedReader inReader_ = null;
    private static BufferedWriter outWriter_ = null;
    private static int termFieldNum_ = 1;
    private static Vector outputFieldList_ = new Vector();
    private static String outputTerm_ = new String();
    private static String promptStr_ = null;

    public static void main(String[] stringArray) {
        wordInd wordInd2;
        String string = "";
        Option option = new Option(string);
        if (stringArray.length > 0) {
            string = "";
            int n = 0;
            while (n < stringArray.length) {
                string = n == 0 ? stringArray[n] : string + " " + stringArray[n];
                ++n;
            }
            option = new Option(string);
        }
        if (SystemOption.CheckSyntax(option, (wordInd2 = new wordInd()).GetOption(), false, true)) {
            wordInd2.ExecuteCommands(option, wordInd2.GetOption());
            if (runFlag_) {
                wordInd.GetVariants();
            }
        } else {
            WordIndHelp.WordIndHelp();
        }
    }

    public static void GetVariants() {
        if (inReader_ == null) {
            inReader_ = new BufferedReader(new InputStreamReader(System.in));
        }
        try {
            do {
                if (!promptFlag_) continue;
                wordInd.GetPrompt();
            } while (wordInd.LineHandler(inReader_.readLine()));
            wordInd.Close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void ExecuteCommand(OptionItem optionItem, Option option) {
        OptionItem optionItem2 = OptionUtility.GetItemByName(optionItem, option, false);
        Vector vector = option.GetOptionItems();
        if (SystemOption.CheckOption(optionItem2, "-c")) {
            reserveCaseFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-F:INT")) {
            Integer n = new Integer(optionItem2.GetOptionArgument());
            outputFieldList_.addElement(n);
        } else if (SystemOption.CheckOption(optionItem2, "-h")) {
            WordIndHelp.WordIndHelp();
            runFlag_ = false;
        } else if (SystemOption.CheckOption(optionItem2, "-hs")) {
            option.PrintOptionHierachy();
            runFlag_ = false;
        } else if (SystemOption.CheckOption(optionItem2, "-i:STR")) {
            String string = optionItem2.GetOptionArgument();
            if (string != null) {
                try {
                    inReader_ = new BufferedReader(new FileReader(string));
                }
                catch (IOException iOException) {
                    runFlag_ = false;
                    System.err.println("**Error: problem of opening/reading file " + string);
                }
            }
        } else if (SystemOption.CheckOption(optionItem2, "-n")) {
            noOutputFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-o:STR")) {
            String string = optionItem2.GetOptionArgument();
            if (string != null) {
                try {
                    outWriter_ = new BufferedWriter(new FileWriter(string));
                }
                catch (IOException iOException) {
                    runFlag_ = false;
                    System.err.println("**Error: problem of opening/writing file " + string);
                }
            }
        } else if (SystemOption.CheckOption(optionItem2, "-p")) {
            promptFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-s:STR")) {
            separator_ = optionItem2.GetOptionArgument();
        } else if (SystemOption.CheckOption(optionItem2, "-t:INT")) {
            termFieldNum_ = Integer.parseInt(optionItem2.GetOptionArgument());
        } else if (SystemOption.CheckOption(optionItem2, "-v")) {
            try {
                Out.Println(outWriter_, "wordInd.2003", false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            runFlag_ = false;
        }
    }

    protected void DefineFlag() {
        String string = "-c -F:INT -h -hs -i:STR -n -o:STR -p -s:STR -t:INT -v";
        this.systemOption_ = new Option(string);
        this.systemOption_.SetFlagFullName("-c", "Reserve_Cases");
        this.systemOption_.SetFlagFullName("-F", "Copy_Field_To_Outputs");
        this.systemOption_.SetFlagFullName("-h", "Help");
        this.systemOption_.SetFlagFullName("-hs", "Hierarchy_Struture");
        this.systemOption_.SetFlagFullName("-i", "Input_File");
        this.systemOption_.SetFlagFullName("-n", "No_Output");
        this.systemOption_.SetFlagFullName("-o", "Output_File");
        this.systemOption_.SetFlagFullName("-p", "Show_Prompt");
        this.systemOption_.SetFlagFullName("-s", "Field_Separator");
        this.systemOption_.SetFlagFullName("-t", "Term_Field");
        this.systemOption_.SetFlagFullName("-v", "Version");
    }

    private static void Close() throws IOException, SQLException {
        if (outWriter_ != null) {
            outWriter_.close();
        }
        if (inReader_ != null) {
            inReader_.close();
        }
    }

    private static void GetPrompt() throws IOException {
        Out.Println(outWriter_, promptStr_, false);
    }

    private static boolean LineHandler(String string) throws SQLException, IOException {
        LexItem lexItem;
        Vector vector;
        if (string == null) {
            return false;
        }
        String string2 = In.GetField(string, separator_, termFieldNum_);
        outputTerm_ = In.GetOutTerm(string, separator_, outputFieldList_);
        if (!reserveCaseFlag_) {
            string2 = string2.toLowerCase();
        }
        if ((vector = ToTokenize.Mutate(lexItem = new LexItem(string2), false, false)).size() == 0) {
            if (noOutputFlag_) {
                Out.Println(outWriter_, outputTerm_ + NO_OUTPUT_STR, false);
            }
        } else {
            int n = 0;
            while (n < vector.size()) {
                LexItem lexItem2 = (LexItem)vector.elementAt(n);
                Out.Println(outWriter_, outputTerm_ + lexItem2.GetTargetTerm(), false);
                ++n;
            }
        }
        return true;
    }

    static {
        promptStr_ = Platform.IsWindow() ? "- Please input a term (type \"Ctl-z\" then \"Enter\" to quit) >" : "- Please input a term (type \"Ctl-d\" to quit) >";
    }
}

