/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.text.VariantFormatter;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.SingletonDataSetManager;
import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.view.TextFieldView;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.io.Serializable;

public class TextFieldControl
extends TextFieldView
implements DataChangeListener,
AccessListener,
WritableSingletonModel,
BlackBox,
ColumnAware,
Serializable {
    private DataSet dataSet;
    private String columnName;
    private boolean addNotifyCalled = false;

    public TextFieldControl() {
        this.setModel(new BasicSingletonContainer());
    }

    public void setModel(SingletonModel sm) {
        if (sm == this) {
            throw new IllegalArgumentException(Res._RecursiveModel);
        }
        super.setModel(sm);
    }

    protected void updateText() {
        VariantFormatter formatter;
        Column column;
        if (this.model != null && this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null && (formatter = column.getFormatter()) != null) {
            Object data = this.model.get();
            int selectionStart = this.getSelectionStart();
            int selectionEnd = this.getSelectionEnd();
            String text = "";
            try {
                text = formatter.format(data);
            }
            catch (Exception x) {
                DataSetModel.handleException(this.dataSet, this, x);
                return;
            }
            this.setSuperText(text != null ? text : "");
            this.setSelectionStart(selectionStart);
            this.setSelectionEnd(selectionEnd);
            return;
        }
        super.updateText();
    }

    public void setText(String text) {
        VariantFormatter formatter;
        Column column;
        if (this.canSet(true) && !this.locateOnly && this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null && (formatter = column.getFormatter()) != null) {
            Object data = null;
            try {
                data = formatter.parse(text);
            }
            catch (Exception x) {
                DataSetModel.handleException(this.dataSet, this, x);
                return;
            }
            try {
                this.writeModel.set(data);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        super.setText(text);
    }

    protected void postText() {
        VariantFormatter formatter;
        Column column;
        if (this.canSet(true) && !this.locateOnly && this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null && (formatter = column.getFormatter()) != null) {
            String text = super.getText();
            Object data = null;
            try {
                data = formatter.parse(text);
            }
            catch (Exception x) {
                DataSetModel.handleException(this.dataSet, this, x);
                return;
            }
            try {
                this.writeModel.set(data);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        super.postText();
    }

    public void accessChange(AccessEvent e) {
        switch (e.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception ex) {
                    e.appendException(ex);
                }
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void dataChanged(DataChangeEvent e) {
    }

    private String formatData() {
        Column column;
        String text = "";
        if (this.model != null && this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            Object data = this.model.get();
            if (data != null) {
                VariantFormatter formatter = column.getFormatter();
                if (formatter != null) {
                    try {
                        text = formatter.format(data);
                    }
                    catch (Exception x) {
                        DataSetModel.handleException(this.dataSet, this, x);
                    }
                } else {
                    text = data.toString();
                }
            }
        } else {
            text = this.getText();
        }
        return text;
    }

    public void postRow(DataChangeEvent e) throws Exception {
        if (!this.formatData().equals(this.getText())) {
            this.postText();
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet newDataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener((AccessListener)this);
            this.dataSet.removeDataChangeListener((DataChangeListener)this);
        }
        this.openDataSet(newDataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener((AccessListener)this);
            this.dataSet.addDataChangeListener((DataChangeListener)this);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String newColumnName) {
        this.columnName = newColumnName;
        if (this.addNotifyCalled) {
            this.openDataSet(this.dataSet);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    private void openDataSet(DataSet newDataSet) {
        this.dataSet = newDataSet;
        if (this.dataSet == null) {
            this.setModel(new BasicSingletonContainer());
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException ex) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)ex));
                this.setModel(new BasicSingletonContainer());
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    private void bindDataSet() {
        Column column;
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            this.setModel(new SingletonDataSetManager(this.dataSet, column, this));
            this.bindProperties(column);
        }
    }

    private void bindProperties(Column column) {
        Color bg = column.getBackground();
        Color fg = column.getForeground();
        Font f = column.getFont();
        if (bg != null) {
            this.setBackground(bg);
        }
        if (fg != null) {
            this.setForeground(fg);
        }
        if (f != null) {
            this.setFont(f);
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if (e.getID() != 401 || e.isConsumed() || this.dataSet == null || !this.dataSet.isOpen()) {
            return;
        }
        try {
            switch (e.getKeyCode()) {
                case 155: {
                    if (this.postOnFocusLost) {
                        this.postText();
                    }
                    this.dataSet.insertRow(false);
                    break;
                }
                case 127: {
                    if (e.isControlDown()) {
                        this.dataSet.deleteRow();
                    }
                    break;
                }
                case 34: {
                    if (this.postOnFocusLost) {
                        this.postText();
                    }
                    this.dataSet.next();
                    break;
                }
                case 33: {
                    if (this.postOnFocusLost) {
                        this.postText();
                    }
                    this.dataSet.prior();
                }
            }
        }
        catch (DataSetException dataSetException) {
            // empty catch block
        }
    }

    public Object get() {
        return this.getModel().get();
    }

    public void set(Object data) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().set(data);
        }
    }

    public void touched() {
        if (this.getWriteModel() != null) {
            this.getWriteModel().touched();
        }
    }

    public void enableModelEvents(boolean enable) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().enableModelEvents(enable);
        }
    }
}

