/*
 * Decompiled with CFR 0.152.
 */
package GuiTool.Gui;

import GuiTool.Global.LvgDef;
import GuiTool.Global.LvgGlobal;
import GuiTool.Gui.CategoryDialog;
import GuiTool.Gui.InflectionDialog;
import GuiTool.Gui.InputPanel;
import GuiTool.GuiComp.OkCancelResetButtonPanel;
import GuiTool.GuiLib.GridBag;
import GuiTool.GuiLib.LvgHtmlBrowser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class InputOptionDialog
extends JDialog {
    private static final int SIZE = LvgDef.INPUT_OPT_NUM;
    private static final int OFFSET = 2;
    private static JCheckBox[] cb_ = new JCheckBox[SIZE];
    private static JTextField[] valueT_ = new JTextField[SIZE];
    private static JButton[] setB_ = new JButton[SIZE];
    private static JButton[] helpB_ = new JButton[SIZE];
    private static int[] size_ = new int[SIZE];
    private static boolean[] valueTFlag_ = new boolean[]{true, true, true, true, true};
    private static boolean[] setBFlag_ = new boolean[]{true, true, false, false, false};
    private static String[] defaults_ = new String[SIZE];
    private static String[] cancelText_ = new String[SIZE];
    private static boolean[] cancelCb_ = new boolean[SIZE];
    private static final int INPUT_NUM = 2;
    private static final int SCREEN_INPUT = 0;
    private static final int FILE_INPUT = 1;
    private static JRadioButton[] rb_ = new JRadioButton[2];
    private static ButtonGroup rbGroup_ = null;
    private static ButtonGroup catGroup_ = null;
    private static ButtonGroup inflGroup_ = null;
    private static JFrame owner_ = null;
    private static InputOptionDialog dialog_ = null;
    private static LvgHtmlBrowser helpDoc_ = null;

    private InputOptionDialog(JFrame jFrame) {
        super(jFrame);
        this.setTitle("Lvg Input Options");
        this.setModal(true);
        owner_ = jFrame;
        this.setLocationRelativeTo(jFrame);
        this.setSize(420, 480);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Please select input options:"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Categories and Inflections"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        GridBag.SetWeight(gridBagConstraints, 100, 100);
        int n = 0;
        while (n < 2) {
            GridBag.SetPosSize(gridBagConstraints, 0, n, 1, 1);
            jPanel2.add((Component)cb_[n], gridBagConstraints);
            GridBag.SetPosSize(gridBagConstraints, 1, n, 1, 1);
            jPanel2.add((Component)valueT_[n], gridBagConstraints);
            if (setBFlag_[n]) {
                GridBag.SetPosSize(gridBagConstraints, 2, n, 1, 1);
                jPanel2.add((Component)setB_[n], gridBagConstraints);
            }
            ++n;
        }
        GridBag.SetWeight(gridBagConstraints, 100, 100);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Input Filter Options"));
        jPanel3.setLayout(gridBagLayout);
        int n2 = 2;
        while (n2 < SIZE - 1) {
            GridBag.SetPosSize(gridBagConstraints, 0, n2, 1, 1);
            jPanel3.add((Component)cb_[n2], gridBagConstraints);
            GridBag.SetPosSize(gridBagConstraints, 1, n2, 1, 1);
            jPanel3.add((Component)valueT_[n2], gridBagConstraints);
            GridBag.SetPosSize(gridBagConstraints, 2, n2, 1, 1);
            jPanel3.add((Component)helpB_[n2], gridBagConstraints);
            ++n2;
        }
        valueT_[5].setText(LvgGlobal.inFile_.getPath());
        GridBag.SetWeight(gridBagConstraints, 100, 100);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Input Source Options"));
        jPanel4.setLayout(gridBagLayout);
        int n3 = 0;
        while (n3 < 2) {
            GridBag.SetPosSize(gridBagConstraints, n3, 0, 1, 1);
            jPanel4.add((Component)rb_[n3], gridBagConstraints);
            ++n3;
        }
        GridBag.SetPosSize(gridBagConstraints, 2, 0, 1, 1);
        jPanel4.add((Component)setB_[5], gridBagConstraints);
        GridBag.SetPosSize(gridBagConstraints, 3, 0, 1, 1);
        jPanel4.add((Component)helpB_[5], gridBagConstraints);
        GridBag.SetPosSize(gridBagConstraints, 1, 1, 3, 1);
        jPanel4.add((Component)valueT_[5], gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(6, 12, 6, 12);
        GridBag.SetPosSize(gridBagConstraints, 1, 1, 1, 1);
        jPanel5.add((Component)jPanel2, gridBagConstraints);
        GridBag.SetPosSize(gridBagConstraints, 1, 2, 1, 1);
        jPanel5.add((Component)jPanel3, gridBagConstraints);
        GridBag.SetPosSize(gridBagConstraints, 1, 3, 1, 1);
        jPanel5.add((Component)jPanel4, gridBagConstraints);
        OkCancelResetButtonPanel okCancelResetButtonPanel = new OkCancelResetButtonPanel();
        JButton jButton = okCancelResetButtonPanel.GetOkButton();
        JButton jButton2 = okCancelResetButtonPanel.GetCancelButton();
        JButton jButton3 = okCancelResetButtonPanel.GetResetButton();
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)jPanel5, "Center");
        this.getContentPane().add((Component)okCancelResetButtonPanel, "South");
        rb_[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                valueT_[5].setEditable(false);
            }
        });
        rb_[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                valueT_[5].setEditable(true);
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LvgGlobal.cmd_.ResetInputOptions();
                int n = 2;
                while (n < SIZE) {
                    if (cb_[n].isSelected()) {
                        LvgGlobal.cmd_.AddInputOption("-" + LvgDef.INPUT_PURE_OPT_FLAG[n] + ":" + valueT_[n].getText());
                    }
                    ++n;
                }
                LvgGlobal.UpdateCmdStr();
                InputPanel.SetShowFile(LvgGlobal.inputFromScreen_);
                LvgGlobal.inFile_ = new File(valueT_[5].getText());
                InputPanel.SetFile(LvgGlobal.inFile_.getPath());
                LvgGlobal.inputFromScreen_ = rb_[0].isSelected();
                InputOptionDialog.this.setVisible(false);
                SwingUtilities.updateComponentTreeUI(owner_);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputOptionDialog.RetrieveStatus();
                InputOptionDialog.this.setVisible(false);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputOptionDialog.ResetCheckBox();
                int n = 0;
                while (n < SIZE) {
                    valueT_[n].setText(defaults_[n]);
                    ++n;
                }
                InputOptionDialog.SetSourceToScreen();
            }
        });
        setB_[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryDialog.ShowDialog(owner_, valueT_[0], valueT_[1]);
            }
        });
        setB_[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InflectionDialog.ShowDialog(owner_, valueT_[1], valueT_[0]);
            }
        });
        setB_[5].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setSelectedFile(new File(valueT_[5].getText()));
                jFileChooser.setDialogTitle("Choose the input file");
                jFileChooser.setMultiSelectionEnabled(false);
                if (jFileChooser.showDialog(owner_, "Select") == 0) {
                    valueT_[5].setText(jFileChooser.getSelectedFile().getPath());
                }
            }
        });
        helpB_[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputOptionDialog.this.ShowHelp(2);
            }
        });
        helpB_[3].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputOptionDialog.this.ShowHelp(3);
            }
        });
        helpB_[4].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputOptionDialog.this.ShowHelp(4);
            }
        });
        helpB_[5].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputOptionDialog.this.ShowHelp(5);
            }
        });
    }

    public static void ShowDialog(JFrame jFrame) {
        if (dialog_ == null) {
            dialog_ = new InputOptionDialog(jFrame);
        }
        InputOptionDialog.StoreStatus();
        dialog_.show();
    }

    public static int GetTermFieldNum() {
        int n = 1;
        if (cb_[2].isSelected()) {
            n = Integer.parseInt(valueT_[2].getText());
        }
        return n;
    }

    public static long GetCategory() {
        long l = Long.parseLong(valueT_[0].getText());
        return l;
    }

    public static void SetCategory(long l) {
        valueT_[0].setText(Long.toString(l));
    }

    public static long GetInflection() {
        long l = Long.parseLong(valueT_[1].getText());
        return l;
    }

    public static void SetInflection(long l) {
        valueT_[1].setText(Long.toString(l));
    }

    public static void ResetCheckBox() {
        int n = 0;
        while (n < SIZE) {
            if (n < 2) {
                cb_[n].setSelected(true);
            } else {
                cb_[n].setSelected(false);
            }
            ++n;
        }
    }

    public static void SetSourceToScreen() {
        rb_[0].setSelected(true);
        LvgGlobal.inputFromScreen_ = true;
        valueT_[5].setEditable(false);
    }

    public static int GetCategoryFieldNum() {
        int n = -1;
        if (cb_[3].isSelected()) {
            n = Integer.parseInt(valueT_[3].getText());
        }
        return n;
    }

    public static int GetInflectionFieldNum() {
        int n = -1;
        if (cb_[3].isSelected()) {
            n = Integer.parseInt(valueT_[4].getText());
        }
        return n;
    }

    private static void StoreStatus() {
        int n = 0;
        while (n < SIZE) {
            InputOptionDialog.cancelCb_[n] = cb_[n].isSelected();
            InputOptionDialog.cancelText_[n] = valueT_[n].getText();
            ++n;
        }
    }

    private static void RetrieveStatus() {
        int n = 0;
        while (n < SIZE) {
            cb_[n].setSelected(cancelCb_[n]);
            valueT_[n].setText(cancelText_[n]);
            ++n;
        }
        rb_[0].setSelected(LvgGlobal.inputFromScreen_);
        rb_[1].setSelected(!LvgGlobal.inputFromScreen_);
    }

    private void ShowHelp(int n) {
        String string = LvgGlobal.config_.GetConfiguration("LVG_DIR");
        String string2 = "file:" + string + "docs/designDoc/LifeCycle/requirement/lvgOptions/" + LvgDef.INPUT_OPT_DOC[n];
        if (helpDoc_ == null) {
            String string3 = "Input Filter Option Documents";
            String string4 = "file:" + string + "docs/designDoc/LifeCycle/requirement/lvgInputFilter.html";
            helpDoc_ = new LvgHtmlBrowser(owner_, string3, 600, 800, string4, string2);
        } else {
            helpDoc_.SetPage(string2);
        }
        helpDoc_.setVisible(true);
    }

    static {
        InputOptionDialog.defaults_[0] = Long.toString(2047L);
        InputOptionDialog.defaults_[1] = Long.toString(0xFFFFFFL);
        InputOptionDialog.defaults_[2] = "1";
        InputOptionDialog.defaults_[3] = "0";
        InputOptionDialog.defaults_[4] = "0";
        InputOptionDialog.defaults_[5] = LvgGlobal.inFile_.getPath();
        InputOptionDialog.size_[0] = 4;
        InputOptionDialog.size_[1] = 8;
        InputOptionDialog.size_[3] = 3;
        InputOptionDialog.size_[4] = 3;
        InputOptionDialog.size_[2] = 3;
        int n = 0;
        while (n < SIZE) {
            if (n < 2) {
                InputOptionDialog.cb_[n] = new JCheckBox(LvgDef.INPUT_OPT[n]);
                cb_[n].setSelected(true);
            } else {
                InputOptionDialog.cb_[n] = new JCheckBox(LvgDef.INPUT_OPT[n] + " (-" + LvgDef.INPUT_OPT_FLAG[n] + ")");
            }
            InputOptionDialog.setB_[n] = new JButton("Setting");
            setB_[n].setPreferredSize(new Dimension(100, 21));
            InputOptionDialog.helpB_[n] = new JButton("Help");
            helpB_[n].setPreferredSize(new Dimension(50, 21));
            InputOptionDialog.valueT_[n] = new JTextField(defaults_[n], size_[n]);
            ++n;
        }
        valueT_[5].setEditable(false);
        InputOptionDialog.rb_[0] = new JRadioButton("Screen");
        InputOptionDialog.rb_[1] = new JRadioButton("File");
        rb_[0].setSelected(true);
        rbGroup_ = new ButtonGroup();
        rbGroup_.add(rb_[0]);
        rbGroup_.add(rb_[1]);
        catGroup_ = new ButtonGroup();
        catGroup_.add(cb_[0]);
        catGroup_.add(cb_[3]);
        inflGroup_ = new ButtonGroup();
        inflGroup_.add(cb_[1]);
        inflGroup_.add(cb_[4]);
    }
}

