/*
 * Decompiled with CFR 0.152.
 */
package GuiTool.Gui;

import GuiTool.Global.LvgGlobal;
import GuiTool.Gui.OutputOptionDialog;
import GuiTool.Gui.ViewLexItemsDialog;
import GuiTool.GuiLib.GridBag;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class OutputPanel
extends JPanel {
    private static final String LVG_BANNER = "*** Welcome to Lexical Tool ***";
    private static Vector banner_ = new Vector();
    private static JList lvgOutputs_ = null;
    private static JFrame owner_ = null;
    private static OutputPanel outputP_ = null;

    private OutputPanel(JFrame jFrame) {
        owner_ = jFrame;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Outputs"));
        JScrollPane jScrollPane = new JScrollPane(lvgOutputs_);
        JButton jButton = new JButton("Options");
        JButton jButton2 = new JButton("Reset");
        JButton jButton3 = new JButton("Details");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 3, 5, 3);
        GridBag.SetWeight(gridBagConstraints, 100, 100);
        GridBag.SetPosSize(gridBagConstraints, 1, 1, 5, 1);
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        GridBag.SetPosSize(gridBagConstraints, 2, 2, 1, 1);
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        GridBag.SetPosSize(gridBagConstraints, 3, 2, 1, 1);
        this.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        GridBag.SetPosSize(gridBagConstraints, 4, 2, 1, 1);
        this.add((Component)jButton3, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputOptionDialog.ShowDialog(owner_);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                lvgOutputs_.setListData(banner_);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = lvgOutputs_.getSelectedIndex();
                Vector vector = LvgGlobal.GetOutputLexItems();
                ViewLexItemsDialog viewLexItemsDialog = new ViewLexItemsDialog(owner_, vector, "LVG Output - LexItems Details", "Output LexItems Deatils", n);
                viewLexItemsDialog.show();
            }
        });
    }

    public static JPanel GetPanel(JFrame jFrame) {
        if (outputP_ == null) {
            outputP_ = new OutputPanel(jFrame);
        }
        return outputP_;
    }

    public static void UpdateResult() {
        Vector vector = LvgGlobal.GetOutputStrings();
        if (vector.size() == 0) {
            lvgOutputs_.setListData(banner_);
        } else {
            lvgOutputs_.setListData(vector);
            lvgOutputs_.setSelectedIndex(0);
        }
    }

    public static void SetSelectedIndex(int n) {
        lvgOutputs_.setSelectedIndex(n);
    }

    public static JList GetOutputList() {
        return lvgOutputs_;
    }

    public static void SetOutputMessage() {
        String string = "*** Results are sent to the file below ***";
        Vector<String> vector = new Vector<String>();
        vector.addElement(string);
        vector.addElement("    '" + LvgGlobal.outFile_.getPath() + "'");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        vector.addElement("    @ " + gregorianCalendar.getTime().toString());
        lvgOutputs_.setListData(vector);
    }

    static {
        banner_.addElement(LVG_BANNER);
        lvgOutputs_ = new JList(banner_);
        lvgOutputs_.setFont(new Font("Dialog", 0, 14));
    }
}

