/*
 * Decompiled with CFR 0.152.
 */
package GuiTool.GuiComp;

import GuiTool.Global.LvgDef;
import GuiTool.GuiLib.Handler;
import GuiTool.GuiLib.LibCloseableFrame;
import gov.nih.nlm.nls.lvg.Lib.CatInfl;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class InflectionPanel
extends JPanel {
    private JCheckBox[] cb_ = new JCheckBox[LvgDef.INFLECTION_NUM];

    public InflectionPanel(ActionListener actionListener, int n) {
        int n2 = (int)Math.ceil((double)LvgDef.INFLECTION_NUM / (double)n);
        this.setLayout(new GridLayout(n2, n, 5, 3));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Inflections"));
        int n3 = 0;
        while (n3 < LvgDef.INFLECTION_NUM) {
            this.cb_[n3] = new JCheckBox(LvgDef.INFLECTION[n3] + " (" + LvgDef.INFLECTION_VALUE[n3] + ")");
            this.cb_[n3].addActionListener(actionListener);
            this.add(this.cb_[n3]);
            ++n3;
        }
    }

    public void UpdateCheckBox(long l) {
        int n = 0;
        while (n < LvgDef.INFLECTION_NUM) {
            Vector vector = Category.ToValues(l);
            boolean bl = false;
            int n2 = 0;
            while (n2 < vector.size()) {
                long l2 = (Long)vector.elementAt(n2);
                bl = bl || CatInfl.IsRelated(l2, Inflection.GetBitValue(n));
                ++n2;
            }
            this.cb_[n].setEnabled(bl);
            ++n;
        }
    }

    public void ResetCheckBox() {
        int n = 0;
        while (n < LvgDef.INFLECTION_NUM) {
            this.cb_[n].setEnabled(true);
            ++n;
        }
    }

    public JCheckBox[] GetCheckBox() {
        return this.cb_;
    }

    public static void main(String[] stringArray) {
        LibCloseableFrame libCloseableFrame = new LibCloseableFrame("Inflection Panel");
        libCloseableFrame.setContentPane(new InflectionPanel(new Handler(), 3));
        libCloseableFrame.setSize(900, 250);
        libCloseableFrame.show();
    }
}

