/*
 * Decompiled with CFR 0.152.
 */
package GuiTool.GuiLib;

import GuiTool.GuiLib.GridBag;
import GuiTool.GuiLib.LibCloseableFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class LvgHtmlBrowser
extends JDialog
implements ActionListener {
    private JEditorPane htmlPane_ = null;
    private JScrollPane scrollPane_ = null;
    private JPanel mainPane_ = null;
    private JButton backB_ = new JButton("Back");
    private JButton forwardB_ = new JButton("Forward");
    private JButton reloadB_ = new JButton("Reload");
    private JButton homeB_ = new JButton("Home");
    private JButton closeB_ = new JButton("Close");
    private LinkedList urlHistory_ = new LinkedList();
    private int urlIndex_ = -1;
    private String homeUrl_ = null;

    public LvgHtmlBrowser(JFrame jFrame, String string, String string2) {
        super(jFrame, string, true);
        this.setLocationRelativeTo(jFrame);
        this.setSize(500, 700);
        try {
            this.htmlPane_ = new JEditorPane(string2);
            this.urlHistory_.add(string2);
            ++this.urlIndex_;
            this.homeUrl_ = string2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            System.exit(1);
        }
        this.htmlPane_.setEditable(false);
        this.scrollPane_ = new JScrollPane(this.htmlPane_);
        JPanel jPanel = new JPanel();
        jPanel.add(this.backB_);
        jPanel.add(this.forwardB_);
        jPanel.add(this.reloadB_);
        jPanel.add(this.homeB_);
        jPanel.add(this.closeB_);
        this.backB_.addActionListener(this);
        this.forwardB_.addActionListener(this);
        this.reloadB_.addActionListener(this);
        this.homeB_.addActionListener(this);
        this.closeB_.addActionListener(this);
        this.mainPane_ = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mainPane_.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        GridBag.SetPosSize(gridBagConstraints, 0, 0, 1, 1);
        this.mainPane_.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        GridBag.SetPosSize(gridBagConstraints, 0, 1, 1, 1);
        this.mainPane_.add((Component)this.scrollPane_, gridBagConstraints);
        this.getContentPane().add(this.mainPane_);
        this.ActiveHyperLink();
    }

    public LvgHtmlBrowser(JFrame jFrame, String string, String string2, String string3) {
        this(jFrame, string, string3);
        this.homeUrl_ = string2;
    }

    public LvgHtmlBrowser(JFrame jFrame, String string, int n, int n2, String string2) {
        this(jFrame, string, string2);
        this.setSize(n, n2);
    }

    public LvgHtmlBrowser(JFrame jFrame, String string, int n, int n2, String string2, String string3) {
        this(jFrame, string, n, n2, string3);
        this.homeUrl_ = string2;
    }

    public void SetPage(String string) {
        this.GoToUrl(string);
        this.urlIndex_ = 0;
        this.urlHistory_.clear();
        this.urlHistory_.add(string);
    }

    public void SetHome(String string) {
        this.homeUrl_ = string;
    }

    public JEditorPane GetHtmlPane() {
        return this.htmlPane_;
    }

    public JPanel GetMainPane() {
        return this.mainPane_;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.backB_) {
            if (this.urlIndex_ > 0) {
                String string = (String)this.urlHistory_.get(this.urlIndex_ - 1);
                this.GoToUrl(string);
                --this.urlIndex_;
            }
        } else if (object == this.forwardB_) {
            if (this.urlIndex_ + 1 < this.urlHistory_.size()) {
                String string = (String)this.urlHistory_.get(this.urlIndex_ + 1);
                this.GoToUrl(string);
                ++this.urlIndex_;
            }
        } else if (object == this.reloadB_) {
            String string = (String)this.urlHistory_.get(this.urlIndex_);
            this.GoToUrl(string);
        } else if (object == this.homeB_) {
            this.GoToUrl(this.homeUrl_);
            this.urlHistory_.add(this.homeUrl_);
            ++this.urlIndex_;
        } else if (object == this.closeB_) {
            this.setVisible(false);
        }
    }

    public static void main(String[] stringArray) {
        LibCloseableFrame libCloseableFrame = new LibCloseableFrame();
        libCloseableFrame.setTitle("Html Browser");
        LvgHtmlBrowser lvgHtmlBrowser = new LvgHtmlBrowser(libCloseableFrame, "Lvg Help Document", 500, 700, "http://cgsb9.nlm.nih.gov:8758/lvg/docs/designDoc/index.html", "http://cgsb9.nlm.nih.gov:8758/lvg/docs/designDoc/flow/lowercase.html");
        lvgHtmlBrowser.setVisible(true);
    }

    private void ActiveHyperLink() {
        this.htmlPane_.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                try {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        LvgHtmlBrowser.this.htmlPane_.setPage(hyperlinkEvent.getURL());
                        int n = LvgHtmlBrowser.this.urlHistory_.size();
                        if (LvgHtmlBrowser.this.urlIndex_ + 1 < n) {
                            int n2 = LvgHtmlBrowser.this.urlIndex_ + 1;
                            while (n2 < n) {
                                LvgHtmlBrowser.this.urlHistory_.removeLast();
                                ++n2;
                            }
                        }
                        LvgHtmlBrowser.this.urlIndex_++;
                        LvgHtmlBrowser.this.urlHistory_.add(hyperlinkEvent.getURL().toString());
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        });
    }

    private void GoToUrl(String string) {
        try {
            this.htmlPane_.setPage(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }
}

