/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.example;

import gov.nih.nlm.kss.api.KSSRetrieverV3_0;
import gov.nih.nlm.kss.util.DatabaseException;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Vector;

public class ClientV3_0 {
    private static PrintStream out;
    private static ClientV3_0 instance;

    private static int outputMenu(BufferedReader br) {
        System.out.println("\nUMLSKS ClientV3_0 Menu: ");
        String tab = "    ";
        System.out.println(tab + " 1) Find Semantic Type");
        System.out.println(tab + " 2) Get Semantic Type Properties");
        System.out.println(tab + " 3) Get Semantic Type Ancestors");
        System.out.println(tab + " 4) Get Semantic Type Siblings");
        System.out.println(tab + " 5) List Semantic Type Identifiers");
        System.out.println(tab + " 6) Find Semantic Relation");
        System.out.println(tab + " 7) Get Semantic Relation Properties");
        System.out.println(tab + " 8) Get Semantic Relation Ancestors");
        System.out.println(tab + " 9) List Semantic Relation Identifiers");
        System.out.println(tab + "10) Check For Associative Relation Existence");
        System.out.println(tab + "11) Retrieve Associative Relation");
        System.out.println(tab + "12) Check for Hierarchical Relation Existence");
        System.out.println(tab + "13) List Semantic Groups");
        System.out.println(tab + "14) List Semantic Types for Semantic Group");
        System.out.println(tab + "15) Retriever Semantic Network ASCII Records");
        System.out.println(tab + "16) Get Semantic Group for CUI");
        System.out.println(tab + "'q' to Quit client");
        System.out.println();
        System.out.print("Selection: ");
        String select = ClientV3_0.getString(br);
        select = select.toLowerCase();
        if (select.equals("q")) {
            System.out.println();
            return 0;
        }
        Integer i = null;
        try {
            i = new Integer(select);
        }
        catch (NumberFormatException ex) {
            System.out.println("Either 'q' or a number must be entered");
            return ClientV3_0.outputMenu(br);
        }
        int selection = i;
        if (selection < 1 || selection > 16) {
            System.out.println("Either 'q' or a number must be entered");
            return ClientV3_0.outputMenu(br);
        }
        return selection;
    }

    public static void main(String[] args) {
        KSSRetrieverV3_0 retriever = null;
        if (args.length == 0) {
            System.out.println(" Call syntax:  ClientV3_0 <server host> <server name>");
            System.out.print(" Example:      ClientV3_0 umlsks.nlm.nih.gov ");
            System.out.println("KSSRetriever");
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        try {
            String host = args[0];
            String name = "//" + host + "/" + args[1];
            retriever = (KSSRetrieverV3_0)Naming.lookup(name);
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            return;
        }
        catch (NotBoundException nbex) {
            System.err.println("NotBoundException: " + nbex.getMessage());
            return;
        }
        catch (MalformedURLException mfurl) {
            System.err.println("MalformedURLException: " + mfurl.getMessage());
            return;
        }
        boolean done = false;
        while (!done) {
            int menuChoice = ClientV3_0.outputMenu(br);
            switch (menuChoice) {
                case 0: {
                    done = true;
                    break;
                }
                case 1: {
                    ClientV3_0.findST(br, retriever);
                    break;
                }
                case 2: {
                    ClientV3_0.getSTProps(br, retriever);
                    break;
                }
                case 3: {
                    ClientV3_0.getSTAncs(br, retriever);
                    break;
                }
                case 4: {
                    ClientV3_0.getSTSibs(br, retriever);
                    break;
                }
                case 5: {
                    ClientV3_0.listSTIds(br, retriever);
                    break;
                }
                case 6: {
                    ClientV3_0.findSR(br, retriever);
                    break;
                }
                case 7: {
                    ClientV3_0.getSRProps(br, retriever);
                    break;
                }
                case 8: {
                    ClientV3_0.getSRAncs(br, retriever);
                    break;
                }
                case 9: {
                    ClientV3_0.listSRIds(br, retriever);
                    break;
                }
                case 10: {
                    ClientV3_0.existsAssocRel(br, retriever);
                    break;
                }
                case 11: {
                    ClientV3_0.getAssocRel(br, retriever);
                    break;
                }
                case 12: {
                    ClientV3_0.existsHierRel(br, retriever);
                    break;
                }
                case 13: {
                    ClientV3_0.listSemGroups(br, retriever);
                    break;
                }
                case 14: {
                    ClientV3_0.listSTsForGroup(br, retriever);
                    break;
                }
                case 15: {
                    ClientV3_0.getASCII(br, retriever);
                    break;
                }
                case 16: {
                    ClientV3_0.getGroupForCUI(br, retriever);
                }
            }
        }
        Object var1_1 = null;
    }

    private static void findST(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "findSemType";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String st = ClientV3_0.getString(br, "Enter semantic type search string: ");
        String exp = ClientV3_0.getString(br, "Retrieve expanded tree? (Y/N): ");
        boolean expandTree = true;
        if (!exp.toUpperCase().equals("Y")) {
            expandTree = false;
        }
        String output = ClientV3_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV3_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.findSemType(dbyear, st, expandTree);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void getSTProps(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "getSemTypeProperties";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String rel = ClientV3_0.getString(br, "Enter semantic type STY/TUI: ");
        String exp = ClientV3_0.getString(br, "Retrieve expanded tree? (Y/N): ");
        boolean expandTree = true;
        if (!exp.toUpperCase().equals("Y")) {
            expandTree = false;
        }
        String output = ClientV3_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV3_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.getSemTypeProperties(dbyear, rel, expandTree);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void getSTAncs(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "getSemTypeAncestors";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String rel = ClientV3_0.getString(br, "Enter semantic type STY/TUI: ");
        String exp = ClientV3_0.getString(br, "Retrieve expanded tree? (Y/N): ");
        boolean expandTree = true;
        if (!exp.toUpperCase().equals("Y")) {
            expandTree = false;
        }
        String output = ClientV3_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV3_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.getSemTypeAncestors(dbyear, rel, expandTree);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void getSTSibs(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "getSemTypeSiblings";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String rel = ClientV3_0.getString(br, "Enter semantic type STY/TUI: ");
        String exp = ClientV3_0.getString(br, "Retrieve expanded tree? (Y/N): ");
        boolean expandTree = true;
        if (!exp.toUpperCase().equals("Y")) {
            expandTree = false;
        }
        String output = ClientV3_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV3_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.getSemTypeSiblings(dbyear, rel, expandTree);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void listSTIds(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "listSemTypeIds";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String output = ClientV3_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV3_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.listSemTypeIds(dbyear);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void findSR(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "findSemRelation";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String rel = ClientV3_0.getString(br, "Enter relation search string: ");
        String exp = ClientV3_0.getString(br, "Retrieve expanded tree? (Y/N): ");
        boolean expandTree = true;
        if (!exp.toUpperCase().equals("Y")) {
            expandTree = false;
        }
        String output = ClientV3_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV3_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.findSemRelation(dbyear, rel, expandTree);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void getSRProps(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "getSemRelationProperties";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String rel = ClientV3_0.getString(br, "Enter relation STY/TUI: ");
        String exp = ClientV3_0.getString(br, "Retrieve expanded tree? (Y/N): ");
        boolean expandTree = true;
        if (!exp.toUpperCase().equals("Y")) {
            expandTree = false;
        }
        String output = ClientV3_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV3_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.getSemRelationProperties(dbyear, rel, expandTree);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void getSRAncs(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "getSemRelationAncestors";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String rel = ClientV3_0.getString(br, "Enter relation STY/TUI: ");
        String exp = ClientV3_0.getString(br, "Retrieve expanded tree? (Y/N): ");
        boolean expandTree = true;
        if (!exp.toUpperCase().equals("Y")) {
            expandTree = false;
        }
        String output = ClientV3_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV3_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.getSemRelationAncestors(dbyear, rel, expandTree);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void listSRIds(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "listSemRelationIds";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String output = ClientV3_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV3_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.listSemRelationIds(dbyear);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void existsAssocRel(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "existsAssociativeRelation";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String st1 = ClientV3_0.getString(br, "Enter left-hand side semantic type STY/TUI: ");
        String rel = ClientV3_0.getString(br, "Enter relation STY/TUI: ");
        String st2 = ClientV3_0.getString(br, "Enter right-hand side semantic type STY/TUI: ");
        String output = ClientV3_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV3_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.existsAssociativeRelation(dbyear, st1, rel, st2);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void getAssocRel(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "getAssociativeRelations";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String st1 = ClientV3_0.getString(br, "Enter left-hand side semantic type STY/TUI: ");
        String rel = ClientV3_0.getString(br, "Enter relation STY/TUI: ");
        String st2 = ClientV3_0.getString(br, "Enter right-hand side semantic type STY/TUI: ");
        String exp = ClientV3_0.getString(br, "Retrieve expanded tree? (Y/N): ");
        boolean expandTree = true;
        if (!exp.toUpperCase().equals("Y")) {
            expandTree = false;
        }
        String output = ClientV3_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV3_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.getAssociativeRelations(dbyear, st1, rel, st2, expandTree);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void existsHierRel(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "existsHierRelRelation";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String rel1 = ClientV3_0.getString(br, "Enter left-hand side relation STY/TUI: ");
        String rel = ClientV3_0.getString(br, "Enter relation STY/TUI: ");
        String rel2 = ClientV3_0.getString(br, "Enter right-hand side relation STY/TUI: ");
        String output = ClientV3_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV3_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.existsHierRelRelation(dbyear, rel1, rel, rel2);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void listSemGroups(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "listSemGroups";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String output = ClientV3_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV3_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.listSemGroups(dbyear);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void listSTsForGroup(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "listSemTypes";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String semGroup = ClientV3_0.getString(br, "Enter the semantic group: ");
        String output = ClientV3_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV3_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.listSemTypes(dbyear, semGroup);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void getASCII(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "getSemNetASCIIRecords";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String tableName = ClientV3_0.getString(br, "Enter the table name whose raw records are to be returned: ");
        System.out.print("Output ");
        System.out.print(tableName);
        System.out.print(" records to 1) the screen or 2) a file: ");
        String output = ClientV3_0.getString(br);
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV3_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.getSemNetASCIIRecords(dbyear, tableName);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void getGroupForCUI(BufferedReader br, KSSRetrieverV3_0 retriever) {
        String cmdName = "getSemGroup";
        String dbyear = ClientV3_0.getString(br, "Enter UMLS Release Year: ");
        String cui = ClientV3_0.getString(br, "Enter CUI (e.g. C0001175): ");
        String output = ClientV3_0.getString(br, "Output contents to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            System.out.print("Enter output file name: ");
            outputFileName = ClientV3_0.getString(br);
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.getSemGroup(dbyear, cui);
            long end = System.currentTimeMillis();
            ClientV3_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void showResults(long start, long end, String cmdString, char[] result, boolean screenOutput, String outputFileName) {
        long interval = end - start;
        System.out.println();
        System.out.println("\t" + cmdString + " in XML took " + interval + " milliseconds");
        String xml = new String(result);
        if (screenOutput) {
            out.println(xml);
        } else {
            ClientV3_0.writeFile(outputFileName, xml);
        }
    }

    private static void writeFile(String outputFileName, String xml) {
        try {
            PrintStream fos = new PrintStream((OutputStream)new FileOutputStream(outputFileName), true, "UTF-8");
            fos.println(xml);
            fos.close();
        }
        catch (IOException ex) {
            System.out.println("IOException: " + ex.getMessage());
        }
    }

    private static String getString(BufferedReader br) {
        String str = null;
        try {
            str = br.readLine();
        }
        catch (IOException iex) {
            System.err.println("IOException: " + iex.getMessage());
        }
        return str;
    }

    private static String getString(BufferedReader br, String prompt) {
        String str = null;
        System.out.print(prompt);
        try {
            str = br.readLine();
        }
        catch (IOException iex) {
            System.err.println("IOException: " + iex.getMessage());
        }
        return str;
    }

    private static Vector multiValPrompt(BufferedReader br, String prompt) {
        Vector<String> values = new Vector<String>();
        System.out.println(prompt);
        String str = null;
        while (!(str = ClientV3_0.getString(br)).equals("")) {
            values.addElement(str);
            if (!str.equals("")) continue;
        }
        return values;
    }

    private ClientV3_0() {
    }

    public static ClientV3_0 getInstance() {
        if (instance == null) {
            instance = new ClientV3_0();
        }
        return instance;
    }
}

