/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.example;

import gov.nih.nlm.kss.api.KSSRetrieverV4_0;
import gov.nih.nlm.kss.util.DatabaseException;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Vector;

public class ClientV4_0 {
    private static PrintStream out;
    private static ClientV4_0 instance;

    private static int outputMenu(BufferedReader br) {
        System.out.println("\nUMLSKS ClientV4_0 Menu: ");
        String tab = "    ";
        System.out.println(tab + " 1) List Metathesaurus Raw ASCII Table Names");
        System.out.println(tab + " 2) List Semantic Network Raw ASCII Table Names");
        System.out.println(tab + " 3) Find Basic Semantic Type");
        System.out.println(tab + " 4) Find Basic Semantic Relation");
        System.out.println(tab + " 5) Find Basic Associative Relation");
        System.out.println(tab + " 6) Retrieve Lexical Records for a Term");
        System.out.println(tab + "'q' to Quit client");
        System.out.println();
        System.out.print("Selection: ");
        String select = ClientV4_0.getString(br);
        select = select.toLowerCase();
        if (select.equals("q")) {
            System.out.println();
            return 0;
        }
        Integer i = null;
        try {
            i = new Integer(select);
        }
        catch (NumberFormatException ex) {
            System.out.println("Either 'q' or a number must be entered");
            return ClientV4_0.outputMenu(br);
        }
        int selection = i;
        if (selection < 1 || selection > 6) {
            System.out.println("Either 'q' or a number must be entered");
            return ClientV4_0.outputMenu(br);
        }
        return selection;
    }

    public static void main(String[] args) {
        KSSRetrieverV4_0 retriever = null;
        if (args.length == 0) {
            System.out.println(" Call syntax:  ClientV4_0 <server host> <server name>");
            System.out.print(" Example:      ClientV4_0 umlsks.nlm.nih.gov ");
            System.out.println("KSSRetriever");
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        try {
            String host = args[0];
            String name = "//" + host + "/" + args[1];
            retriever = (KSSRetrieverV4_0)Naming.lookup(name);
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            return;
        }
        catch (NotBoundException nbex) {
            System.err.println("NotBoundException: " + nbex.getMessage());
            return;
        }
        catch (MalformedURLException mfurl) {
            System.err.println("MalformedURLException: " + mfurl.getMessage());
            return;
        }
        boolean done = false;
        while (!done) {
            int menuChoice = ClientV4_0.outputMenu(br);
            switch (menuChoice) {
                case 0: {
                    done = true;
                    break;
                }
                case 1: {
                    ClientV4_0.listMetaTables(br, retriever);
                    break;
                }
                case 2: {
                    ClientV4_0.listSemTables(br, retriever);
                    break;
                }
                case 3: {
                    ClientV4_0.findBasicSemType(br, retriever);
                    break;
                }
                case 4: {
                    ClientV4_0.findBasicSemRelation(br, retriever);
                    break;
                }
                case 5: {
                    ClientV4_0.getBasicAssociative(br, retriever);
                    break;
                }
                case 6: {
                    ClientV4_0.getLexRecords(br, retriever);
                }
            }
        }
        Object var1_1 = null;
    }

    private static void listMetaTables(BufferedReader br, KSSRetrieverV4_0 retriever) {
        String cmdName = "listMetaTableNames";
        String dbyear = ClientV4_0.getString(br, "Enter UMLS Release Year: ");
        String output = ClientV4_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV4_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.listMetaTableNames(dbyear);
            long end = System.currentTimeMillis();
            ClientV4_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void listSemTables(BufferedReader br, KSSRetrieverV4_0 retriever) {
        String cmdName = "listSemNetTableNames";
        String dbyear = ClientV4_0.getString(br, "Enter UMLS Release Year: ");
        String output = ClientV4_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV4_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.listSemNetTableNames(dbyear);
            long end = System.currentTimeMillis();
            ClientV4_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void findBasicSemType(BufferedReader br, KSSRetrieverV4_0 retriever) {
        String cmdName = "findBasicSemType";
        String dbyear = ClientV4_0.getString(br, "Enter UMLS Release Year: ");
        String contains = ClientV4_0.getString(br, "Enter Search Term: ");
        String expand = ClientV4_0.getString(br, "Expand the hierarchy? (Y/N): ");
        String output = ClientV4_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV4_0.getString(br, "Enter output file name: ");
        }
        boolean exp = false;
        if (expand.toLowerCase().equals("y")) {
            exp = true;
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.findBasicSemType(dbyear, contains, exp);
            long end = System.currentTimeMillis();
            ClientV4_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void findBasicSemRelation(BufferedReader br, KSSRetrieverV4_0 retriever) {
        String cmdName = "findBasicSemRelation";
        String dbyear = ClientV4_0.getString(br, "Enter UMLS Release Year: ");
        String contains = ClientV4_0.getString(br, "Enter Search Term: ");
        String expand = ClientV4_0.getString(br, "Expand the hierarchy? (Y/N): ");
        String output = ClientV4_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV4_0.getString(br, "Enter output file name: ");
        }
        boolean exp = false;
        if (expand.toLowerCase().equals("y")) {
            exp = true;
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.findBasicSemRelation(dbyear, contains, exp);
            long end = System.currentTimeMillis();
            ClientV4_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void getBasicAssociative(BufferedReader br, KSSRetrieverV4_0 retriever) {
        String cmdName = "getBasicAssociativeRelations";
        String dbyear = ClientV4_0.getString(br, "Enter UMLS Release Year: ");
        String lhs = ClientV4_0.getString(br, "Enter LHS Semantic Type: ");
        String rel = ClientV4_0.getString(br, "Enter Relation: ");
        String rhs = ClientV4_0.getString(br, "Enter RHS Semantic Type: ");
        String expand = ClientV4_0.getString(br, "Expand the hierarchy? (Y/N): ");
        String output = ClientV4_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV4_0.getString(br, "Enter output file name: ");
        }
        boolean exp = false;
        if (expand.toLowerCase().equals("y")) {
            exp = true;
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.getBasicAssociativeRelations(dbyear, lhs, rel, rhs, exp);
            long end = System.currentTimeMillis();
            ClientV4_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void getLexRecords(BufferedReader br, KSSRetrieverV4_0 retriever) {
        String cmdName = "getLexicalRecords";
        String dbyear = ClientV4_0.getString(br, "Enter UMLS Release Year: ");
        String term = ClientV4_0.getString(br, "Enter Term: ");
        String output = ClientV4_0.getString(br, "Output results to 1) the screen or 2) a file: ");
        output = output.toLowerCase();
        boolean screenOutput = true;
        String outputFileName = "";
        if (output.equals("2")) {
            screenOutput = false;
            outputFileName = ClientV4_0.getString(br, "Enter output file name: ");
        }
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.getLexicalRecords(dbyear, term);
            long end = System.currentTimeMillis();
            ClientV4_0.showResults(start, end, cmdName, result, screenOutput, outputFileName);
        }
        catch (DatabaseException ex) {
            System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
        }
    }

    private static void showResults(long start, long end, String cmdString, char[] result, boolean screenOutput, String outputFileName) {
        long interval = end - start;
        System.out.println();
        System.out.println("\t" + cmdString + " in XML took " + interval + " milliseconds");
        String xml = new String(result);
        if (screenOutput) {
            out.println(xml);
        } else {
            ClientV4_0.writeFile(outputFileName, xml);
        }
    }

    private static void writeFile(String outputFileName, String xml) {
        try {
            PrintStream fos = new PrintStream((OutputStream)new FileOutputStream(outputFileName), true, "UTF-8");
            fos.println(xml);
            fos.close();
        }
        catch (IOException ex) {
            System.out.println("IOException: " + ex.getMessage());
        }
    }

    private static String getString(BufferedReader br) {
        String str = null;
        try {
            str = br.readLine();
        }
        catch (IOException iex) {
            System.err.println("IOException: " + iex.getMessage());
        }
        return str;
    }

    private static String getString(BufferedReader br, String prompt) {
        String str = null;
        System.out.print(prompt);
        try {
            str = br.readLine();
        }
        catch (IOException iex) {
            System.err.println("IOException: " + iex.getMessage());
        }
        return str;
    }

    private static Vector multiValPrompt(BufferedReader br, String prompt) {
        Vector<String> values = new Vector<String>();
        System.out.println(prompt);
        String str = null;
        while (!(str = ClientV4_0.getString(br)).equals("")) {
            values.addElement(str);
            if (!str.equals("")) continue;
        }
        return values;
    }

    private ClientV4_0() {
    }

    public static ClientV4_0 getInstance() {
        if (instance == null) {
            instance = new ClientV4_0();
        }
        return instance;
    }
}

