/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.example;

import gov.nih.nlm.kss.api.KSSRetrieverV4_2;
import gov.nih.nlm.kss.util.DatabaseException;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClientV4_2 {
    private static PrintStream out;
    private static ClientV4_2 instance;

    private static int outputMenu(BufferedReader br) {
        System.out.println("\nUMLSKS ClientV4_2 Menu:");
        String tab = "    ";
        System.out.println(tab + " 1) Find Terms");
        System.out.println(tab + " 2) Retrieve List of UMLS Changes");
        System.out.println(tab + " 3) Retrieve List of Metadata Descriptions");
        System.out.println(tab + "'q' to Quit client");
        System.out.println();
        System.out.print("Selection: ");
        String select = ClientV4_2.getString(br);
        select = select.toLowerCase();
        if (select.equals("q")) {
            System.out.println();
            return 0;
        }
        Integer i = null;
        try {
            i = new Integer(select);
        }
        catch (NumberFormatException ex) {
            System.out.println("Either 'q' or a number must be entered");
            return ClientV4_2.outputMenu(br);
        }
        int selection = i;
        if (selection < 1 || selection > 3) {
            System.out.println("Either 'q' or a number must be entered");
            return ClientV4_2.outputMenu(br);
        }
        return selection;
    }

    public static void main(String[] args) {
        KSSRetrieverV4_2 retriever = null;
        if (args.length == 0) {
            System.out.println(" Call syntax:  ClientV4_2 <server host> <server name>");
            System.out.print(" Example:      ClientV4_2 umlsks.nlm.nih.gov ");
            System.out.println("KSSRetriever");
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        try {
            String host = args[0];
            String name = "//" + host + "/" + args[1];
            retriever = (KSSRetrieverV4_2)Naming.lookup(name);
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            return;
        }
        catch (NotBoundException nbex) {
            System.err.println("NotBoundException: " + nbex.getMessage());
            return;
        }
        catch (MalformedURLException mfurl) {
            System.err.println("MalformedURLException: " + mfurl.getMessage());
            return;
        }
        boolean done = false;
        while (!done) {
            int menuChoice = ClientV4_2.outputMenu(br);
            switch (menuChoice) {
                case 0: {
                    done = true;
                    break;
                }
                case 1: {
                    ClientV4_2.requestTerms(br, retriever);
                    break;
                }
                case 2: {
                    ClientV4_2.requestUMLSChanges(br, retriever);
                    break;
                }
                case 3: {
                    ClientV4_2.requestMRDocContents(br, retriever);
                    break;
                }
                default: {
                    done = true;
                }
            }
        }
        Object var1_1 = null;
    }

    private static void requestTerms(BufferedReader br, KSSRetrieverV4_2 retriever) {
        block6: {
            System.out.print("Enter UMLS Release Year: ");
            String dbYear = ClientV4_2.getString(br);
            System.out.print("Enter term name: ");
            String term = ClientV4_2.getString(br);
            Vector sabs = ClientV4_2.multiValPrompt(br, "Enter Root SABs (eg:MSH), one per line; empty line to end:");
            System.out.print("Enter the language (empty for no retriction): ");
            String language = ClientV4_2.getString(br);
            System.out.print("Include suppressible synonyms, if applicable (Y/N): ");
            String incSup = ClientV4_2.getString(br);
            boolean incSupps = false;
            if (incSup.toUpperCase().equals("Y")) {
                incSupps = true;
            }
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = ClientV4_2.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = ClientV4_2.getString(br);
            }
            String cmdName = "findTerms";
            try {
                long start = System.currentTimeMillis();
                char[] result = null;
                result = retriever.findTerms(dbYear, term, sabs, language, incSupps);
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tgetTerms for '" + term + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block6;
                }
                ClientV4_2.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestUMLSChanges(BufferedReader br, KSSRetrieverV4_2 retriever) {
        block7: {
            System.out.print("Enter UMLS release:");
            String release = ClientV4_2.getString(br);
            System.out.print("Enter Specific UMLS Years separated by commas ");
            System.out.print("(or leave blank for all): ");
            String years = ClientV4_2.getString(br);
            StringTokenizer tokenizer = new StringTokenizer(years, ",");
            Vector<String> umlsyrs = new Vector<String>();
            while (tokenizer.hasMoreTokens()) {
                umlsyrs.add(tokenizer.nextToken());
            }
            System.out.print("Enter Specific CUIs separated by commas ");
            System.out.print("(or leave blank for all): ");
            String cuistr = ClientV4_2.getString(br);
            tokenizer = new StringTokenizer(cuistr, ",");
            Vector<String> cuis = new Vector<String>();
            while (tokenizer.hasMoreTokens()) {
                cuis.add(tokenizer.nextToken());
            }
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = ClientV4_2.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = ClientV4_2.getString(br);
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = retriever.describeUMLSChanges(release, umlsyrs, cuis);
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tdescribeUMLSChanges ' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block7;
                }
                ClientV4_2.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println("describeUMLSChanges: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("describeUMLSChanges: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestMRDocContents(BufferedReader br, KSSRetrieverV4_2 retriever) {
        block5: {
            System.out.print("Enter UMLS release:");
            String release = ClientV4_2.getString(br);
            System.out.print("Enter Metadata Type ");
            System.out.print("(or leave blank for all): ");
            String metaType = ClientV4_2.getString(br);
            System.out.print("Enter Metadata Subtype ");
            System.out.print("(or leave blank for all): ");
            String metaSubType = ClientV4_2.getString(br);
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = ClientV4_2.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = ClientV4_2.getString(br);
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = retriever.listDocEntryTypes(release, metaType, metaSubType);
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tlistDocEntryTypes ' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block5;
                }
                ClientV4_2.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println("listDocEntryTypes: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("listDocEntryTypes: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void writeFile(String outputFileName, String xml) {
        try {
            PrintStream fos = new PrintStream((OutputStream)new FileOutputStream(outputFileName), true, "UTF-8");
            fos.println(xml);
            fos.close();
        }
        catch (IOException ex) {
            System.out.println("IOException: " + ex.getMessage());
        }
    }

    private static String getString(BufferedReader br) {
        String str = null;
        try {
            str = br.readLine();
        }
        catch (IOException iex) {
            System.err.println("IOException: " + iex.getMessage());
        }
        return str;
    }

    private static Vector multiValPrompt(BufferedReader br, String prompt) {
        Vector<String> values = new Vector<String>();
        System.out.println(prompt);
        String str = null;
        while (!(str = ClientV4_2.getString(br)).equals("")) {
            values.addElement(str);
            if (!str.equals("")) continue;
        }
        return values;
    }

    private ClientV4_2() {
    }

    public static ClientV4_2 getInstance() {
        if (instance == null) {
            instance = new ClientV4_2();
        }
        return instance;
    }

    class ClientV4_2Entry {
        String dbYear;
        public Vector cuisOrConNames;
        public Vector sabs;
        public String language;
        boolean cuiEntered;
        boolean incSupps;
        int operator;
        boolean screenOutput;
        String outputFileName;

        public void output() {
            System.out.println("CUIs/TermNames = " + this.cuisOrConNames);
            System.out.println("SABs = " + this.sabs);
            System.out.println("language = '" + this.language + "'");
            System.out.println("cuiEntered = '" + this.cuiEntered + "'");
            System.out.println("incSupps = '" + this.incSupps + "'");
            System.out.println("operator = '" + this.operator + "'");
        }

        public ClientV4_2Entry(Vector cuis, Vector srcs, String lang, boolean cui, boolean inc, int op) {
            this.cuisOrConNames = cuis;
            this.sabs = srcs;
            this.language = lang;
            this.cuiEntered = cui;
            this.incSupps = inc;
            this.operator = op;
        }

        public ClientV4_2Entry() {
        }
    }
}

