/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.example;

import gov.nih.nlm.kss.api.KSSRetrieverV2_1;
import gov.nih.nlm.kss.util.DatabaseException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public class ExpertClient {
    private static String getString(BufferedReader br) {
        String str = null;
        try {
            str = br.readLine();
        }
        catch (IOException iex) {
            System.err.println("IOException: " + iex.getMessage());
        }
        return str;
    }

    public static void main(String[] args) {
        BufferedReader br;
        KSSRetrieverV2_1 retriever = null;
        if (args.length == 0) {
            System.out.print(" Call syntax:  ExpertClient <server host> ");
            System.out.print("<server name> <xmlQueryFile>");
            System.out.print(" Example:\t  ExpertClient umlsks.nlm.nih.gov ");
            System.out.print("TestRetriever ./query.xml");
            return;
        }
        String xmlQueryFile = args[2];
        String xmlQuery = null;
        try {
            br = new BufferedReader(new FileReader(xmlQueryFile));
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = br.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            xmlQuery = xml.toString();
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + xmlQueryFile + "'");
            return;
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + xmlQueryFile + "'");
            return;
        }
        try {
            String host = args[0];
            String name = "//" + host + "/" + args[1];
            retriever = (KSSRetrieverV2_1)Naming.lookup(name);
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            return;
        }
        catch (NotBoundException nbex) {
            System.err.println("NotBoundException: " + nbex.getMessage());
            return;
        }
        catch (MalformedURLException mfurl) {
            System.err.println("MalformedURLException: " + mfurl.getMessage());
            return;
        }
        br = null;
        try {
            br = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        System.out.print("Enter Database Year: ");
        String dbYear = ExpertClient.getString(br);
        try {
            long start = System.currentTimeMillis();
            char[] result = retriever.query(dbYear, xmlQuery);
            long end = System.currentTimeMillis();
            long interval = end - start;
            System.out.println("\tQuery execution took " + interval + " milliseconds");
            if (result == null) {
                System.out.println("No results returned");
                return;
            }
            String xml = new String(result);
            System.out.println(xml);
        }
        catch (DatabaseException ex) {
            System.err.println("query: DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println("query: RemoteException-> " + ex.getMessage());
        }
        Object var1_1 = null;
    }
}

