/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.example;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;

public class SocketClient {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: gov.nih.nlm.kss.example.SocketClient <host> <port> <xmlCmdFile>");
            return;
        }
        Integer portn = new Integer(args[1]);
        Socket socket = null;
        try {
            socket = new Socket(args[0], (int)portn);
        }
        catch (IOException ex) {
            System.err.println("Server Connection-IOException: " + ex.getMessage());
            return;
        }
        catch (SecurityException ex) {
            System.err.println("Server Connection-SecurityException: " + ex.getMessage());
            return;
        }
        String xmlQueryFile = args[2];
        String xmlQuery = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(xmlQueryFile), "UTF-8"));
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = br.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            xmlQuery = xml.toString();
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + xmlQueryFile + "'");
            ex.printStackTrace();
            return;
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + xmlQueryFile + "'");
            ex.printStackTrace();
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        try {
            long start = System.currentTimeMillis();
            SocketClient.writeRequest(socket, xmlQuery);
            String result = SocketClient.readResponse(socket);
            long end = System.currentTimeMillis();
            long interval = end - start;
            System.out.println("\tQuery execution took " + interval + " milliseconds");
            if (result == null) {
                System.out.println("No results returned");
                return;
            }
            String xml = new String(result);
            PrintStream output = new PrintStream((OutputStream)System.out, true, "UTF-8");
            output.println(xml);
        }
        catch (IOException ex) {
            System.err.println("IOException: " + ex.getMessage());
        }
    }

    private static void writeRequest(Socket socket, String xmlQuery) throws IOException {
        PrintStream out = new PrintStream(socket.getOutputStream(), true, "UTF-8");
        out.print(xmlQuery);
        out.println("%%");
        out.flush();
    }

    private static String readResponse(Socket socket) throws IOException {
        BufferedReader input = null;
        try {
            input = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        String line = "";
        StringBuffer result = new StringBuffer(40000);
        int length = 0;
        while ((line = input.readLine()) != null) {
            if (line.equals("%%")) break;
            result.ensureCapacity(length + line.length());
            result.append(line);
            length += line.length();
        }
        return result.toString();
    }
}

