/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.example;

import gov.nih.nlm.kss.query.StandardQueryExecutor;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class StandardQueryClient {
    private static String getString(BufferedReader br) {
        String str = null;
        try {
            str = br.readLine();
        }
        catch (IOException iex) {
            System.err.println("IOException: " + iex.getMessage());
        }
        return str;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.print(" Call syntax:  StandardQueryClient <server host> ");
            System.out.println("<server name> <xmlCommandFile>");
            System.out.print(" Example:\t  StandardQueryClient umlsks.nlm.nih.gov ");
            System.out.println("TestRetriever ./findCUI.xml");
            return;
        }
        String xmlQueryFile = args[2];
        String xmlQuery = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(xmlQueryFile), "UTF-8"));
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = br.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            xmlQuery = xml.toString();
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + xmlQueryFile + "'");
            ex.printStackTrace();
            return;
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + xmlQueryFile + "'");
            ex.printStackTrace();
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        try {
            String host = args[0];
            String name = "//" + host + "/" + args[1];
            StandardQueryExecutor executor = new StandardQueryExecutor(name);
            char[] value = executor.request(xmlQuery);
            PrintStream output = new PrintStream((OutputStream)System.out, true, "UTF-8");
            output.println(new String(value));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }
}

