/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.CompareUtil;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class KSCuiVector
extends KSVector {
    private String cui = "";
    private String cn = "";

    public KSCuiVector(Vector vector, String xmlTag, String xmlStructVersion) {
        super(vector, xmlTag, xmlStructVersion);
    }

    public KSCuiVector(KSCuiVector vector, String xmlTag, String xmlStructVersion) {
        super(vector, xmlTag, xmlStructVersion);
        this.setCUI(vector.getCUI());
        this.setCN(vector.getCN());
    }

    public KSCuiVector(Vector vector) {
        super(vector);
    }

    public KSCuiVector(KSCuiVector vector) {
        super(vector);
        this.setCUI(vector.getCUI());
        this.setCN(vector.getCN());
    }

    public KSCuiVector(String xmlTag, String xmlStructVersion) {
        super(xmlTag, xmlStructVersion);
    }

    public KSCuiVector() {
    }

    public KSCuiVector(String xml, String xmlTag, String xmlStructVersion) throws XMLException {
        super(xmlTag, xmlStructVersion);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        Element cuiChild = root.getChild("cui", namespace);
        if (cuiChild == null) {
            throw new XMLException("No concept unique identifier <cui> tag found");
        }
        this.cui = XMLInterpreter.extractString(cuiChild);
        Element cnChild = root.getChild("cn", namespace);
        if (cnChild == null) {
            throw new XMLException("No concept name <cn> tag found");
        }
        this.cn = XMLInterpreter.extractString(cnChild);
    }

    public void setCUI(String cui) {
        this.cui = cui;
    }

    public String getCUI() {
        return this.cui;
    }

    public void setCN(String cn) {
        this.cn = cn;
    }

    public String getCN() {
        return this.cn;
    }

    protected void writeContents(StringBuffer xml) {
        String tab = "      ";
        xml.ensureCapacity(xml.length() + 300);
        xml.append(tab);
        xml.append("<cui>");
        xml.append(Str.escape(this.cui));
        xml.append("</cui>\n");
        xml.append(tab);
        xml.append("<cn>");
        xml.append(Str.escape(this.cn));
        xml.append("</cn>\n");
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            xml.append(((Xmlizable)iter.next()).xmlize());
        }
    }

    protected boolean doCompare(KSComparable vec, PrintStream out, boolean equalsFlag) {
        if (!(vec instanceof KSCuiVector)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + vec.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        boolean ret = super.doCompare(vec, out, equalsFlag);
        if (!ret & this.performanceMode()) {
            return false;
        }
        KSCuiVector comp = (KSCuiVector)vec;
        if (!Str.compareStr(this.cui, comp.getCUI())) {
            if (out != null) {
                out.println("this->CUI=" + this.cui + " is different from " + comp.getCUI());
            }
            ret = false;
            if (this.performanceMode()) {
                return ret;
            }
        }
        if (!Str.compareStr(CompareUtil.logicalEquivCN(this.cn), CompareUtil.logicalEquivCN(comp.getCN()))) {
            if (out != null) {
                out.println("this->CN=" + this.cn + " is different from " + comp.getCN());
            }
            ret = false;
            if (this.performanceMode()) {
                return ret;
            }
        }
        return ret;
    }
}

