/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.KSStringVector;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class SpellingSuggestionsVector
extends KSStringVector {
    public static final String XmlName = "SpellingSuggestions";
    public static final String XmlStructure = "1.1";
    public static final String XmlSpellName = "spelling";
    public static final String XmlTermName = "for";
    public static final String XmlDictName = "dictionary";
    private String forTerm;
    private String dictionary;

    public SpellingSuggestionsVector(Vector suggs) {
        super(suggs, XmlName, XmlStructure, XmlSpellName);
        this.forTerm = "";
    }

    public SpellingSuggestionsVector(SpellingSuggestionsVector suggs) {
        super(suggs, XmlName, XmlStructure, XmlSpellName);
        this.forTerm = suggs.getSpellingTerm();
        this.dictionary = suggs.getDictionary();
    }

    public SpellingSuggestionsVector(String term, Vector suggs) {
        super(suggs, XmlName, XmlStructure, XmlSpellName);
        this.forTerm = term;
    }

    public SpellingSuggestionsVector() {
        super(XmlName, XmlStructure, XmlSpellName);
        this.forTerm = "";
    }

    public SpellingSuggestionsVector(String xml) throws XMLException {
        super(XmlName, XmlStructure, XmlSpellName);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        super.parse(root, namespace);
        Element forTermEle = root.getChild(XmlTermName, namespace);
        if (forTermEle == null) {
            throw new XMLException("for must be specified");
        }
        this.forTerm = XMLInterpreter.extractString(forTermEle);
        Element dictEle = root.getChild(XmlDictName, namespace);
        if (dictEle == null) {
            throw new XMLException("dictionary must be specified");
        }
        this.dictionary = XMLInterpreter.extractString(dictEle);
    }

    public static SpellingSuggestionsVector getInstance(String xml) {
        SpellingSuggestionsVector aev = null;
        try {
            aev = new SpellingSuggestionsVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public void setSpellingTerm(String term) {
        this.forTerm = term;
    }

    public String getSpellingTerm() {
        return this.forTerm;
    }

    public void setDictionary(String dict) {
        this.dictionary = dict;
    }

    public String getDictionary() {
        return this.dictionary;
    }

    protected void writeContents(StringBuffer xml) {
        if (this.forTerm != null && !this.forTerm.equals("")) {
            xml.ensureCapacity(xml.length() + 30 + this.forTerm.length());
            xml.append("    <");
            xml.append(XmlTermName);
            xml.append(">");
            xml.append(Str.escape(this.forTerm));
            xml.append("</");
            xml.append(XmlTermName);
            xml.append(">\n");
        }
        if (this.dictionary != null && !this.dictionary.equals("")) {
            xml.ensureCapacity(xml.length() + 40 + this.dictionary.length());
            xml.append("    <");
            xml.append(XmlDictName);
            xml.append(">");
            xml.append(this.dictionary);
            xml.append("</");
            xml.append(XmlDictName);
            xml.append(">\n");
        }
        super.writeContents(xml);
    }

    protected boolean doCompare(KSComparable vec, PrintStream out, boolean equalsFlag) {
        if (!(vec instanceof SpellingSuggestionsVector)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + vec.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        boolean val = super.doCompare(vec, out, equalsFlag);
        if (!val & this.performanceMode()) {
            return false;
        }
        if (!vec.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        SpellingSuggestionsVector comp = (SpellingSuggestionsVector)vec;
        if (this.forTerm == null && comp.getSpellingTerm() != null || this.forTerm != null && comp.getSpellingTerm() == null) {
            val = false;
        } else if (this.forTerm != null && !this.forTerm.equals(comp.getSpellingTerm())) {
            if (out != null) {
                out.println("Spelling Terms are different");
            }
            val = false;
            if (this.performanceMode() & !val) {
                return val;
            }
        }
        if (this.dictionary == null && comp.getDictionary() != null || this.dictionary != null && comp.getDictionary() == null) {
            val = false;
        } else if (this.dictionary != null && !this.dictionary.equals(comp.getDictionary())) {
            if (out != null) {
                out.println("Dictionary values are different");
            }
            val = false;
            if (this.performanceMode() & !val) {
                return val;
            }
        }
        return val;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.SpellingSuggestionsVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream output = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            SpellingSuggestionsVector vec = SpellingSuggestionsVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No suggestions read");
                return;
            }
            System.out.println("Number of suggestions: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                String entry = (String)iter.next();
                System.out.println("Entry----------------");
                output.println(entry);
                System.out.println("Entry END------------");
            }
            System.out.println("XML Version:");
            output.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

