/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models;

import gov.nih.nlm.kss.models.KSStringVector;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;

public class UMLSYearVector
extends KSStringVector {
    public static final String XmlName = "UMLSYears";
    public static final String XmlStructure = "1.1";
    public static final String XmlYearName = "year";

    public UMLSYearVector(String xml) throws XMLException {
        super(XmlName, XmlStructure, XmlYearName);
        this.parse(xml);
    }

    public UMLSYearVector(Vector years) {
        super(years, XmlName, XmlStructure, XmlYearName);
    }

    public UMLSYearVector(UMLSYearVector years) {
        super(years, XmlName, XmlStructure, XmlYearName);
    }

    public UMLSYearVector() {
        super(XmlName, XmlStructure, XmlYearName);
    }

    public static UMLSYearVector getInstance(String xml) {
        UMLSYearVector aev = null;
        try {
            aev = new UMLSYearVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.UMLSYearVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream output = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            UMLSYearVector vec = UMLSYearVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No years read");
                return;
            }
            System.out.println("Number of years: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                String year = (String)iter.next();
                System.out.println("UMLSYear----------------");
                System.out.println(year);
                System.out.println("UMLSYear END------------");
            }
            System.out.println("XML Version:");
            output.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

