/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.lex;

import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.lex.LexicalRecord;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.nls.lexCheck.Api.ToJavaObjApi;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

public class LexicalRecordVector
extends KSVector {
    private static String xmlHeader = null;
    public static final String XmlName = "LexicalRecordCollection";
    public static final String XmlStructure = "1.1";

    public LexicalRecordVector(Vector recs) {
        super(recs, XmlName, XmlStructure);
    }

    public LexicalRecordVector(LexicalRecordVector recs) {
        super(recs, XmlName, XmlStructure);
    }

    public LexicalRecordVector() {
        super(XmlName, XmlStructure);
    }

    public LexicalRecordVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(String xml) throws XMLException {
        int start = xml.indexOf("<?");
        int end = xml.indexOf("?>");
        if (start == -1 || end == -1) {
            throw new XMLException("Improperly formed XML document");
        }
        xmlHeader = xml.substring(start, end + 2);
        super.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        String childName;
        List lexrecords;
        StringBuffer buffer = new StringBuffer(5000);
        if (xmlHeader != null) {
            buffer.append(xmlHeader);
        }
        if ((lexrecords = root.getChildren(childName = "lexRecords", namespace)) == null || lexrecords.size() == 0) {
            return;
        }
        int i = 0;
        while (i < lexrecords.size()) {
            Element rel = (Element)lexrecords.get(i);
            XMLOutputter outputter = new XMLOutputter();
            String val = outputter.outputString(rel);
            buffer.ensureCapacity(buffer.length() + val.length() + 5);
            buffer.append(val);
            ++i;
        }
        try {
            StringBuffer buf = new StringBuffer(100);
            buf.append("lexRead-");
            buf.append(System.currentTimeMillis());
            File file = File.createTempFile(buf.toString(), ".tmp");
            BufferedWriter str = new BufferedWriter(new FileWriter(file));
            str.write(buffer.toString());
            str.close();
            Vector records = ToJavaObjApi.ToJavaObjs(file.toString());
            file.delete();
            Iterator iter = records.iterator();
            while (iter.hasNext()) {
                LexRecord rec = (LexRecord)iter.next();
                if (rec == null) {
                    throw new XMLException("Invalid lexical record definition");
                }
                LexicalRecord record = new LexicalRecord(rec);
                this.add(record);
            }
        }
        catch (IOException ex) {
            throw new XMLException("Unable to ingest lexical records vector");
        }
        catch (Exception ex) {
            throw new XMLException("Unable to ingest lexical records vector");
        }
    }

    public static LexicalRecordVector getInstance(String xml) {
        LexicalRecordVector aev = null;
        try {
            aev = new LexicalRecordVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    protected void writeContents(StringBuffer xml) {
        xml.ensureCapacity(xml.length() + 15);
        xml.append("<lexRecords>\n");
        super.writeContents(xml);
        xml.ensureCapacity(xml.length() + 15);
        xml.append("</lexRecords>\n");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.lex.LexicalRecordVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream output = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            LexicalRecordVector vec = LexicalRecordVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No records read");
                return;
            }
            System.out.println("Number of records: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                LexicalRecord record = (LexicalRecord)iter.next();
                System.out.println("LexicalRecord----------------");
                output.println(record.xmlize());
                System.out.println("LexicalRecord END------------");
            }
            System.out.println("XML Version:");
            output.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

