/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta;

import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.meta.DocEntryTypeVector;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class DocEntryVector
extends KSVector {
    public static final String XmlName = "DocEntryTypeCollection";
    public static final String XmlStructure = "1.0";

    public DocEntryVector(Vector typeList) {
        super(typeList, XmlName, XmlStructure);
    }

    public DocEntryVector(DocEntryVector typeList) {
        super(typeList, XmlName, XmlStructure);
    }

    public DocEntryVector() {
        super(XmlName, XmlStructure);
    }

    public DocEntryVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        String childName = "docEntryTypeList";
        List typeLists = root.getChildren(childName, namespace);
        if (typeLists == null || typeLists.size() == 0) {
            return;
        }
        int i = 0;
        while (i < typeLists.size()) {
            Element listElement = (Element)typeLists.get(i);
            DocEntryTypeVector typeList = new DocEntryTypeVector();
            try {
                typeList.parse(listElement, namespace);
            }
            catch (XMLException ex) {
                throw new XMLException("Invalid document entry type list definition");
            }
            this.add(typeList);
            ++i;
        }
    }

    public static DocEntryVector getInstance(String xml) {
        DocEntryVector aev = null;
        try {
            aev = new DocEntryVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public void xmlize(StringBuffer xml) {
        xml.append(this.xmlize());
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.DocEntryVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream output = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            DocEntryVector vec = DocEntryVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No document entry descriptions read");
                return;
            }
            System.out.println("Number of document entry descriptions: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                DocEntryTypeVector docEntryType = (DocEntryTypeVector)iter.next();
                System.out.println("DocEntryTypeVector----------------");
                output.println(docEntryType.xmlize());
                System.out.println("DocEntryTypeVector END------------");
            }
            System.out.println("XML Version:");
            output.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

