/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.assocExp;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.CompareUtil;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class AssociatedExp
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private String sab;
    private String rel;
    private String atx;
    public static final String XmlName = "associatedExp";

    public AssociatedExp() {
        this.sab = "";
        this.rel = "";
        this.atx = "";
    }

    public AssociatedExp(String sab, String rel, String atx) {
        this.sab = sab;
        this.rel = rel;
        this.atx = atx;
    }

    public AssociatedExp(Element assocExp, Namespace namespace) throws XMLException {
        Element sabChild = assocExp.getChild("sab", namespace);
        if (sabChild == null) {
            throw new XMLException("No source abbreviation <sab> tag found");
        }
        this.sab = XMLInterpreter.extractString(sabChild);
        Element relChild = assocExp.getChild("rel", namespace);
        if (relChild == null) {
            throw new XMLException("No relationship <rel> tag found");
        }
        this.rel = XMLInterpreter.extractString(relChild);
        Element atxChild = assocExp.getChild("atx", namespace);
        if (atxChild == null) {
            throw new XMLException("No associated expression value <atx> tag found");
        }
        this.atx = XMLInterpreter.extractString(atxChild);
    }

    public static AssociatedExp getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("associatedExp must be the name of the first element");
            }
            return new AssociatedExp(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public String getSAB() {
        return this.sab;
    }

    public void setSAB(String sab) {
        this.sab = sab;
    }

    public String getREL() {
        return this.rel;
    }

    public void setREL(String rel) {
        this.rel = rel;
    }

    public String getATX() {
        return this.atx;
    }

    public void setATX(String atx) {
        this.atx = atx;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("SAB:      " + this.sab);
        out.println("REL:      " + this.rel);
        out.println("ATX:      " + this.atx);
    }

    public String xmlize() {
        String tab0 = "      ";
        String tab = "         ";
        StringBuffer xml = new StringBuffer(2000);
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.ensureCapacity(xml.length() + 30);
        xml.append("<sab>");
        xml.append(this.sab);
        xml.append("</sab>\n");
        xml.ensureCapacity(xml.length() + 50);
        xml.append(tab);
        xml.append("<rel>");
        xml.append(this.rel);
        xml.append("</rel>\n");
        xml.ensureCapacity(xml.length() + 256);
        xml.append(tab);
        xml.append("<atx>");
        xml.append(Str.escape(this.atx));
        xml.append("</atx>\n");
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
        return xml.toString();
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable ae, PrintStream out, boolean equalsFlag) {
        if (!ae.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        AssociatedExp comp = (AssociatedExp)ae;
        String str = comp.getSAB();
        String cstr = this.sab;
        if (!equalsFlag) {
            str = CompareUtil.logicalEquivSAB(comp.getSAB());
            cstr = CompareUtil.logicalEquivSAB(this.sab);
        }
        boolean ret = true;
        if (!Str.compareStr(cstr, str)) {
            if (out != null) {
                out.println("this->SAB='" + this.sab + "' is different from '" + comp.getSAB() + "'");
            }
            ret = false;
        }
        str = comp.getREL();
        if (!Str.compareStr(this.getREL(), str)) {
            if (out != null) {
                out.println("this->REL='" + this.rel + "' different from '" + str + "'");
            }
            ret = false;
        }
        str = comp.getATX();
        if (!Str.compareStr(this.getATX(), str)) {
            if (out != null) {
                out.println("this->ATX='" + this.atx + "' different from '" + str + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return CompareUtil.logicalEquivSAB(this.sab) + this.rel + this.atx;
    }
}

