/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.assocExp;

import gov.nih.nlm.kss.models.KSCuiVector;
import gov.nih.nlm.kss.models.meta.assocExp.AssociatedExp;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class AssociatedExpVector
extends KSCuiVector {
    public static final String XmlName = "AssociatedExpressionCollection";
    public static final String XmlStructure = "1.0";

    public AssociatedExpVector(Vector assocs) {
        super(assocs, XmlName, XmlStructure);
    }

    public AssociatedExpVector(AssociatedExpVector assocs) {
        super(assocs, XmlName, XmlStructure);
    }

    public AssociatedExpVector() {
        super(XmlName, XmlStructure);
    }

    public AssociatedExpVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        super.parse(root, namespace);
        String childName = "associatedExp";
        List assocExprs = root.getChildren(childName, namespace);
        if (assocExprs == null || assocExprs.size() == 0) {
            return;
        }
        int i = 0;
        while (i < assocExprs.size()) {
            Element assocExp = (Element)assocExprs.get(i);
            AssociatedExp assocExpr = new AssociatedExp(assocExp, namespace);
            if (assocExpr == null) {
                throw new XMLException("Invalid associated expression definition");
            }
            this.add(assocExpr);
            ++i;
        }
    }

    public static AssociatedExpVector getInstance(String xml) {
        AssociatedExpVector aev = null;
        try {
            aev = new AssociatedExpVector(xml);
        }
        catch (XMLException ex) {
            ex.printStackTrace();
            return null;
        }
        return aev;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.assocExp.AssociatedExpVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream output = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            AssociatedExpVector vec = AssociatedExpVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No associated expressions read");
                return;
            }
            System.out.println("Number of associated expressions: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                AssociatedExp assocExp = (AssociatedExp)iter.next();
                System.out.println("AssociatedExp----------------");
                assocExp.output();
                System.out.println("AssociatedExp END------------");
            }
            System.out.println("XML Version:");
            output.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

