/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.attribute;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.ConstantSettings;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class Attr
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private String atn;
    private String aten;
    public static final String XmlName = "stringAttr";
    static boolean initialized = false;
    static HashMap hashMap = new HashMap();

    public Attr() {
        this.atn = "";
        this.aten = "";
    }

    public Attr(String atn, String aten) {
        this.atn = atn;
        this.aten = aten;
    }

    public Attr(Element source, Namespace namespace) throws XMLException {
        Element atnChild = source.getChild("atn", namespace);
        if (atnChild == null) {
            throw new XMLException("No attribute name <atn> found");
        }
        this.atn = XMLInterpreter.extractString(atnChild);
        Element atenChild = source.getChild("aten", namespace);
        if (atenChild == null) {
            throw new XMLException("No attribute value <aten> found");
        }
        this.aten = XMLInterpreter.extractString(atenChild);
    }

    public static Attr getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("stringAttr must be the name of the first element");
            }
            return new Attr(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setATN(String atn) {
        this.atn = atn;
    }

    public String getATN() {
        return this.atn;
    }

    public void setATEN(String aten) {
        this.aten = aten;
    }

    public String getATEN() {
        return this.aten;
    }

    /*
     * WARNING - void declaration
     */
    private static void init() throws Exception {
        String s;
        if (initialized) {
            return;
        }
        initialized = true;
        String fileName = ConstantSettings.getStringAttributeFileName();
        FileReader fr = new FileReader(fileName);
        BufferedReader br = new BufferedReader(fr);
        StringTokenizer st = null;
        String atn = null;
        String aten = null;
        while ((s = br.readLine()) != null) {
            void var3_6;
            st = new StringTokenizer((String)var3_6, "\" |");
            if (st.hasMoreTokens()) {
                atn = st.nextToken();
                aten = st.nextToken();
            }
            hashMap.put(atn, new Attr(atn, aten));
        }
    }

    public static void dumpHashMap() {
        Set set = hashMap.entrySet();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Map.Entry me = i.next();
            System.out.print(me.getKey() + ": ");
            System.out.println(((Attr)me.getValue()).getATEN());
        }
    }

    public static Attr lookup(String atn) {
        try {
            Attr obj;
            if (!initialized) {
                Attr.init();
            }
            if ((obj = (Attr)hashMap.get(atn)) != null) {
                return obj;
            }
            obj = new Attr(atn, "");
            hashMap.put(atn, obj);
            return obj;
        }
        catch (Exception e) {
            System.err.println("Attr.lookup Exception: " + e.getMessage());
            return null;
        }
    }

    public static Vector valids() {
        Vector vector = new Vector();
        Set set = hashMap.entrySet();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Map.Entry me = i.next();
            vector.add(me.getKey());
        }
        return vector;
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(2000);
        String tab0 = "    ";
        String tab1 = "        ";
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab1);
        xml.append("<atn>");
        xml.append(Str.escape(this.atn));
        xml.append("</atn>\n");
        xml.append(tab1);
        xml.append("<aten>");
        xml.append(Str.escape(this.aten));
        xml.append("</aten>\n");
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
        return xml.toString();
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    protected boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof Attr)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        Attr comp = (Attr)c;
        boolean ret = true;
        if (!Str.compareStr(this.atn, comp.getATN())) {
            if (out != null) {
                out.println("this->ATN='" + this.atn + "' different from '" + comp.getATN() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.aten, comp.getATEN())) {
            if (out != null) {
                out.println("this->ATEN='" + this.aten + "' different from '" + comp.getATEN() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.atn;
    }
}

