/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.attribute;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.attribute.Attr;
import gov.nih.nlm.kss.util.CompareUtil;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class AttributeValue
extends XMLInterpreter
implements Serializable,
KSComparable,
Xmlizable {
    public static final String XmlName = "attributes";
    private Attr at;
    private String atui;
    private String satui;
    private String atv;

    public AttributeValue() {
        this.at = null;
        this.atui = "";
        this.satui = "";
        this.atv = "";
    }

    public AttributeValue(Attr at, String atv) {
        this.at = at;
        this.atui = "";
        this.satui = "";
        this.atv = atv;
    }

    public AttributeValue(Attr at, String atui, String satui, String atv) {
        this.at = at;
        this.atui = atui;
        this.satui = satui;
        this.atv = atv;
    }

    public AttributeValue(Element av, Namespace namespace) throws XMLException {
        Element atnChild = av.getChild("atn", namespace);
        if (atnChild == null) {
            throw new XMLException("No attribute name <atn> found ");
        }
        this.at = new Attr(XMLInterpreter.extractString(atnChild), "");
        Element atvChild = av.getChild("atv", namespace);
        if (atvChild == null) {
            throw new XMLException("No attribute value <atv> found ");
        }
        this.atv = XMLInterpreter.extractString(atvChild);
        Element atuiChild = av.getChild("atui", namespace);
        this.atui = atuiChild != null ? XMLInterpreter.extractString(atuiChild) : "";
        Element satuiChild = av.getChild("satui", namespace);
        this.satui = satuiChild != null ? XMLInterpreter.extractString(satuiChild) : "";
    }

    public static AttributeValue getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("attributes must be the name of the first element");
            }
            return new AttributeValue(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setAT(Attr at) {
        this.at = at;
    }

    public Attr getAT() {
        return this.at;
    }

    public void setATUI(String atui) {
        this.atui = atui;
    }

    public String getATUI() {
        return this.atui;
    }

    public void setSATUI(String satui) {
        this.satui = satui;
    }

    public String getSATUI() {
        return this.satui;
    }

    public void setATV(String atv) {
        this.atv = atv;
    }

    public String getATV() {
        return this.atv;
    }

    public void output() {
        PrintStream output;
        try {
            output = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            output = new PrintStream(System.out);
        }
        String tab = "            ";
        output.println("");
        output.println(tab + "AttribName: " + this.getAT().getATN());
        output.println(tab + "ATUI      : " + this.getATUI());
        output.println(tab + "SATUI     : " + this.getSATUI());
        output.println(tab + "AttribVal : " + this.getATV());
    }

    public String xmlize() {
        String tab0 = "               ";
        String tab = "                  ";
        StringBuffer xml = new StringBuffer(500);
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.ensureCapacity(xml.length() + 100);
        if (this.atui != null && !this.atui.equals("")) {
            xml.append(tab);
            xml.append("<atui>");
            xml.append(Str.escape(this.atui));
            xml.append("</atui>\n");
        }
        xml.ensureCapacity(xml.length() + 100);
        if (this.satui != null && !this.satui.equals("")) {
            xml.append(tab);
            xml.append("<satui>");
            xml.append(Str.escape(this.satui));
            xml.append("</satui>\n");
        }
        xml.append(tab);
        xml.append("<atn>");
        xml.append(this.at.getATN());
        xml.append("</atn>\n");
        xml.append(tab);
        xml.append("<atv>");
        xml.append(Str.escape(this.atv));
        xml.append("</atv>\n");
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
        return xml.toString();
    }

    public static String xmlize(String attrName, String attrVal) {
        AttributeValue value = new AttributeValue(new Attr(attrName, ""), attrVal);
        return value.xmlize();
    }

    public static void xmlize(StringBuffer xml, String attrName, String attrVal) {
        AttributeValue value = new AttributeValue(new Attr(attrName, ""), attrVal);
        String xmlstr = value.xmlize();
        xml.ensureCapacity(xmlstr.length() + 30);
        xml.append(xmlstr);
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof AttributeValue)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        AttributeValue comp = (AttributeValue)c;
        boolean ret = true;
        Attr attr = comp.getAT();
        if (this.at == null && attr == null) {
            return true;
        }
        if (this.at != null && attr == null || this.at == null && attr != null) {
            return false;
        }
        String catn = attr.getATN();
        String atn = this.at.getATN();
        if (!Str.compareStr(atn, catn)) {
            if (out != null) {
                out.println("this->ATN='" + atn + "' is different from '" + catn + "'");
            }
            ret = false;
        }
        String caten = attr.getATEN();
        String aten = this.at.getATEN();
        if (!Str.compareStr(aten, caten)) {
            if (out != null) {
                out.println("this->ATEN='" + aten + "' is different from '" + caten + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.getATUI(), comp.getATUI())) {
            if (out != null) {
                out.println("this->ATUI='" + this.getATUI() + "' is different from '" + comp.getATUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.getSATUI(), comp.getSATUI())) {
            if (out != null) {
                out.println("this->SATUI='" + this.getSATUI() + "' is different from '" + comp.getSATUI() + "'");
            }
            ret = false;
        }
        String catv = comp.getATV();
        String latv = this.atv;
        if (!equalsFlag) {
            latv = CompareUtil.logicalEquivATV(atn, this.atv);
            catv = CompareUtil.logicalEquivATV(catn, catv);
        }
        if (!Str.compareStr(latv, catv)) {
            if (out != null) {
                out.println("this->ATV='" + this.atv + "' is different from '" + comp.getATV() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        if (this.atui != null && !this.atui.equals("") && this.satui != null && !this.satui.equals("")) {
            return CompareUtil.logicalEquivATV(this.at.getATN(), this.atv) + this.atui + this.satui;
        }
        return CompareUtil.logicalEquivATV(this.at.getATN(), this.atv);
    }
}

