/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.attribute;

import gov.nih.nlm.kss.models.KSCuiVector;
import gov.nih.nlm.kss.models.meta.attribute.RelationshipAttribute;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class RelationshipAttributeVector
extends KSCuiVector {
    public static final String XmlName = "RelationshipAttributeCollection";
    public static final String XmlStructure = "1.0";
    static /* synthetic */ Class class$gov$nih$nlm$kss$models$meta$attribute$RelationshipAttributeVector;

    public RelationshipAttributeVector(Vector attrs) {
        super(attrs, XmlName, XmlStructure);
    }

    public RelationshipAttributeVector(RelationshipAttributeVector attrs) {
        super(attrs, XmlName, XmlStructure);
    }

    public RelationshipAttributeVector() {
        super(XmlName, XmlStructure);
    }

    public RelationshipAttributeVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        super.parse(root, namespace);
        String childName = "relationshipAttributes";
        List concepts = root.getChildren(childName, namespace);
        if (concepts != null && concepts.size() > 0) {
            int i = 0;
            while (i < concepts.size()) {
                Element termEle = (Element)concepts.get(i);
                RelationshipAttribute term = new RelationshipAttribute(termEle, namespace);
                if (term == null) {
                    throw new XMLException("Invalid term attribute definition");
                }
                this.add(term);
                ++i;
            }
        }
    }

    public static RelationshipAttributeVector getInstance(String xml) {
        RelationshipAttributeVector cv = null;
        try {
            cv = new RelationshipAttributeVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return cv;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print((class$gov$nih$nlm$kss$models$meta$attribute$RelationshipAttributeVector == null ? (class$gov$nih$nlm$kss$models$meta$attribute$RelationshipAttributeVector = RelationshipAttributeVector.class$("gov.nih.nlm.kss.models.meta.attribute.RelationshipAttributeVector")) : class$gov$nih$nlm$kss$models$meta$attribute$RelationshipAttributeVector).getName());
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            RelationshipAttributeVector vec = RelationshipAttributeVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No concepts read");
                return;
            }
            System.out.println("Number of concept attributes: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                RelationshipAttribute term = (RelationshipAttribute)iter.next();
                System.out.println("RelationshipAttribute----------------");
                term.output();
                System.out.println("RelationshipAttribute END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

