/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.assocExp.AssociatedExp;
import gov.nih.nlm.kss.models.meta.assocExp.AssociatedExpVector;
import gov.nih.nlm.kss.models.meta.attribute.TermAttribute;
import gov.nih.nlm.kss.models.meta.attribute.TermAttributeVector;
import gov.nih.nlm.kss.models.meta.concept.Definition;
import gov.nih.nlm.kss.models.meta.concept.DefinitionVector;
import gov.nih.nlm.kss.models.meta.concept.SemType;
import gov.nih.nlm.kss.models.meta.concept.SemTypeVector;
import gov.nih.nlm.kss.models.meta.concept.Term;
import gov.nih.nlm.kss.models.meta.concept.TermVector;
import gov.nih.nlm.kss.models.meta.context.Context;
import gov.nih.nlm.kss.models.meta.context.ContextVector;
import gov.nih.nlm.kss.models.meta.cooccurrence.CooccurrenceVector;
import gov.nih.nlm.kss.models.meta.cooccurrence.CooccurringConcept;
import gov.nih.nlm.kss.models.meta.locator.Locator;
import gov.nih.nlm.kss.models.meta.locator.LocatorVector;
import gov.nih.nlm.kss.models.meta.relation.Relation;
import gov.nih.nlm.kss.models.meta.relation.RelationVector;
import gov.nih.nlm.kss.util.CompareUtil;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class Concept
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private String cui;
    private String cn;
    private TermVector terms;
    private DefinitionVector defs;
    private SemTypeVector stys;
    private ContextVector cxts;
    private RelationVector rels;
    private CooccurrenceVector cocs;
    private TermAttributeVector sats;
    private AssociatedExpVector atxs;
    private LocatorVector locs;
    public static final String XmlName = "concept";
    private boolean performance = false;

    public Concept() {
        this.cui = null;
        this.cn = null;
        this.terms = null;
        this.defs = null;
        this.stys = null;
        this.cxts = null;
        this.rels = null;
        this.cocs = null;
        this.sats = null;
        this.atxs = null;
        this.locs = null;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public Concept(String cui) {
        this.cui = cui;
        this.cn = null;
        this.terms = null;
        this.defs = null;
        this.stys = null;
        this.cxts = null;
        this.rels = null;
        this.cocs = null;
        this.sats = null;
        this.atxs = null;
        this.locs = null;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public Concept(String cui, String cn) {
        this.cui = cui;
        this.cn = cn;
        this.terms = null;
        this.defs = null;
        this.stys = null;
        this.cxts = null;
        this.rels = null;
        this.cocs = null;
        this.sats = null;
        this.atxs = null;
        this.locs = null;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    private void processTerms(List terms, Namespace namespace) throws XMLException {
        TermVector vec = new TermVector();
        int i = 0;
        while (i < terms.size()) {
            Element termElement = (Element)terms.get(i);
            Term t = new Term(termElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse term");
            }
            vec.add(t);
            ++i;
        }
        this.setTerms(vec);
    }

    private void processDef(List defs, Namespace namespace) throws XMLException {
        DefinitionVector vec = new DefinitionVector();
        int i = 0;
        while (i < defs.size()) {
            Element defElement = (Element)defs.get(i);
            Definition t = new Definition(defElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse definition");
            }
            vec.add(t);
            ++i;
        }
        this.setDefs(vec);
    }

    private void processSemType(List stys, Namespace namespace) throws XMLException {
        SemTypeVector vec = new SemTypeVector();
        int i = 0;
        while (i < stys.size()) {
            Element styElement = (Element)stys.get(i);
            SemType t = new SemType(styElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse semantic type");
            }
            vec.add(t);
            ++i;
        }
        this.setSTYs(vec);
    }

    private void processContexts(List contexts, Namespace namespace) throws XMLException {
        ContextVector vec = new ContextVector();
        int i = 0;
        while (i < contexts.size()) {
            Element contextsElement = (Element)contexts.get(i);
            Context t = new Context(contextsElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse contexts");
            }
            vec.add(t);
            ++i;
        }
        this.setCXTs(vec);
    }

    private void processRelations(List relations, Namespace namespace) throws XMLException {
        RelationVector vec = new RelationVector();
        int i = 0;
        while (i < relations.size()) {
            Element relationsElement = (Element)relations.get(i);
            Relation t = new Relation(this.cui, relationsElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse relations");
            }
            t.setCon1(this);
            vec.add(t);
            ++i;
        }
        this.setRels(vec);
    }

    private void processAssocExprs(List assocs, Namespace namespace) throws XMLException {
        AssociatedExpVector vec = new AssociatedExpVector();
        int i = 0;
        while (i < assocs.size()) {
            Element aeElement = (Element)assocs.get(i);
            AssociatedExp t = new AssociatedExp(aeElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse associated expressions");
            }
            vec.add(t);
            ++i;
        }
        this.setATXs(vec);
    }

    private void processCooccurrences(List coocs, Namespace namespace) throws XMLException {
        CooccurrenceVector vec = new CooccurrenceVector();
        int i = 0;
        while (i < coocs.size()) {
            Element coocElement = (Element)coocs.get(i);
            CooccurringConcept t = new CooccurringConcept(this.getCUI(), coocElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse cooccurring concepts");
            }
            vec.add(t);
            ++i;
        }
        this.setCOCs(vec);
    }

    private void processStrAttrs(List attrs, Namespace namespace) throws XMLException {
        TermAttributeVector vec = new TermAttributeVector();
        int i = 0;
        while (i < attrs.size()) {
            Element attrElement = (Element)attrs.get(i);
            TermAttribute t = new TermAttribute(attrElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse string attributes");
            }
            vec.add(t);
            ++i;
        }
        this.setSATs(vec);
    }

    private void processLocators(List locs, Namespace namespace) throws XMLException {
        LocatorVector vec = new LocatorVector();
        int i = 0;
        while (i < locs.size()) {
            Element locElement = (Element)locs.get(i);
            Locator t = new Locator(locElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse locators");
            }
            vec.add(t);
            ++i;
        }
        this.setLOCs(vec);
    }

    public Concept(Element concept, Namespace namespace) throws XMLException {
        Element cuiChild;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        if ((cuiChild = concept.getChild("cui", namespace)) == null) {
            throw new XMLException("No concept unique identifier found");
        }
        this.cui = XMLInterpreter.extractString(cuiChild);
        Element cnChild = concept.getChild("cn", namespace);
        if (cnChild == null) {
            throw new XMLException("No concept name found");
        }
        this.cn = XMLInterpreter.extractString(cnChild);
        List terms = concept.getChildren("term", namespace);
        this.processTerms(terms, namespace);
        List defs = concept.getChildren("definition", namespace);
        this.processDef(defs, namespace);
        List stys = concept.getChildren("semanticType", namespace);
        this.processSemType(stys, namespace);
        List cxts = concept.getChildren("context", namespace);
        this.processContexts(cxts, namespace);
        List rels = concept.getChildren("relation", namespace);
        this.processRelations(rels, namespace);
        List assocs = concept.getChildren("associatedExp", namespace);
        this.processAssocExprs(assocs, namespace);
        List coocs = concept.getChildren("cooccurrence", namespace);
        this.processCooccurrences(coocs, namespace);
        List attrs = concept.getChildren("termAttributes", namespace);
        this.processStrAttrs(attrs, namespace);
        List locs = concept.getChildren("locator", namespace);
        this.processLocators(locs, namespace);
    }

    public static Concept getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("concept must be  the name of the first element");
            }
            return new Concept(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setCUI(String cui) {
        this.cui = cui;
    }

    public void setCN(String cn) {
        this.cn = cn;
    }

    public void setTerms(TermVector terms) {
        this.terms = terms;
    }

    public void setDefs(DefinitionVector defs) {
        this.defs = defs;
    }

    public void setSTYs(SemTypeVector stys) {
        this.stys = stys;
    }

    public void setCXTs(ContextVector cxts) {
        this.cxts = cxts;
    }

    public void setRels(RelationVector rels) {
        this.rels = rels;
    }

    public void setCOCs(CooccurrenceVector cocs) {
        this.cocs = cocs;
    }

    public void setSATs(TermAttributeVector tats) {
        this.sats = tats;
    }

    public void setATXs(AssociatedExpVector atxs) {
        this.atxs = atxs;
    }

    public void setLOCs(LocatorVector locs) {
        this.locs = locs;
    }

    public void addDef(Definition def) {
        if (this.defs == null) {
            this.defs = new DefinitionVector();
        }
        this.defs.addElement(def);
    }

    public void addSTY(SemType sty) {
        if (this.stys == null) {
            this.stys = new SemTypeVector();
        }
        this.stys.addElement(sty);
    }

    public String getCUI() {
        return this.cui;
    }

    public String getCN() {
        return this.cn;
    }

    public Vector getTerms() {
        return this.terms;
    }

    public Vector getDefs() {
        return this.defs;
    }

    public Vector getSTYs() {
        return this.stys;
    }

    public Vector getCXTs() {
        return this.cxts;
    }

    public Vector getRels() {
        return this.rels;
    }

    public Vector getCOCs() {
        return this.cocs;
    }

    public Vector getSATs() {
        return this.sats;
    }

    public Vector getATXs() {
        return this.atxs;
    }

    public Vector getLOCs() {
        return this.locs;
    }

    public Term getTerm(String lui) {
        Vector termList = this.getTerms();
        Iterator vIter2 = termList.iterator();
        while (vIter2.hasNext()) {
            Term term = (Term)vIter2.next();
            if (!term.getLUI().equals(lui)) continue;
            return term;
        }
        return null;
    }

    public String toString() {
        return this.xmlize();
    }

    public void output() {
        Iterator vIter2;
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("CUI:      " + this.cui);
        out.println("Name:     " + this.cn);
        Vector vec = this.getTerms();
        out.println("Terms:    ");
        if (vec != null) {
            vIter2 = vec.iterator();
            while (vIter2.hasNext()) {
                Term term = (Term)vIter2.next();
                term.output();
            }
        } else {
            out.println("     None");
        }
        vec = this.getDefs();
        out.println("Definitions:");
        if (vec != null) {
            vIter2 = vec.iterator();
            while (vIter2.hasNext()) {
                ((Definition)vIter2.next()).output();
            }
        } else {
            out.println("     None");
        }
        vec = this.getSTYs();
        out.println("Semantic Types:");
        if (vec != null) {
            vIter2 = vec.iterator();
            while (vIter2.hasNext()) {
                ((SemType)vIter2.next()).output();
            }
        } else {
            out.println("     None");
        }
        vec = this.getCXTs();
        out.println("Context:");
        if (vec != null) {
            vIter2 = vec.iterator();
            while (vIter2.hasNext()) {
                ((Context)vIter2.next()).output();
            }
        } else {
            out.println("     None");
        }
        vec = this.getRels();
        out.println("Relation:");
        if (vec != null) {
            vIter2 = vec.iterator();
            while (vIter2.hasNext()) {
                ((Relation)vIter2.next()).output();
            }
        } else {
            out.println("     None");
        }
        vec = this.getCOCs();
        out.println("Cooccurrences:");
        if (vec != null) {
            vIter2 = vec.iterator();
            while (vIter2.hasNext()) {
                ((CooccurringConcept)vIter2.next()).output();
            }
        } else {
            out.println("     None");
        }
        vec = this.getSATs();
        out.println("String Attributes:");
        if (vec != null) {
            vIter2 = vec.iterator();
            while (vIter2.hasNext()) {
                ((TermAttribute)vIter2.next()).output();
            }
        } else {
            out.println("     None");
        }
        vec = this.getATXs();
        out.println("Associated Expressions:");
        if (vec != null) {
            vIter2 = vec.iterator();
            while (vIter2.hasNext()) {
                ((AssociatedExp)vIter2.next()).output();
            }
        } else {
            out.println("     None");
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(100000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        Iterator vIter2;
        String tab0 = "   ";
        String tab = "      ";
        xml.ensureCapacity(xml.length() + 350);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.append("<cui>");
        xml.append(this.cui);
        xml.append("</cui>\n");
        xml.append(tab);
        xml.append("<cn>");
        xml.append(Str.escape(this.getCN()));
        xml.append("</cn>\n");
        if (this.terms != null) {
            vIter2 = this.terms.iterator();
            while (vIter2.hasNext()) {
                Term term = (Term)vIter2.next();
                term.xmlize(xml);
            }
        }
        if (this.defs != null) {
            vIter2 = this.defs.iterator();
            while (vIter2.hasNext()) {
                ((Definition)vIter2.next()).xmlize(xml);
            }
        }
        if (this.stys != null) {
            vIter2 = this.stys.iterator();
            while (vIter2.hasNext()) {
                ((SemType)vIter2.next()).xmlize(xml);
            }
        }
        if (this.cxts != null) {
            vIter2 = this.cxts.iterator();
            while (vIter2.hasNext()) {
                ((Context)vIter2.next()).xmlize(xml);
            }
        }
        if (this.rels != null) {
            vIter2 = this.rels.iterator();
            while (vIter2.hasNext()) {
                ((Relation)vIter2.next()).xmlize(xml);
            }
        }
        if (this.atxs != null) {
            vIter2 = this.atxs.iterator();
            while (vIter2.hasNext()) {
                xml.append(((AssociatedExp)vIter2.next()).xmlize());
            }
        }
        if (this.cocs != null) {
            vIter2 = this.cocs.iterator();
            while (vIter2.hasNext()) {
                ((CooccurringConcept)vIter2.next()).xmlize(xml);
            }
        }
        if (this.sats != null) {
            vIter2 = this.sats.iterator();
            while (vIter2.hasNext()) {
                ((TermAttribute)vIter2.next()).xmlize(xml);
            }
        }
        if (this.locs != null) {
            vIter2 = this.locs.iterator();
            while (vIter2.hasNext()) {
                ((Locator)vIter2.next()).xmlize(xml);
            }
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String cn;
        if (!(c instanceof Concept)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        Concept comp = (Concept)c;
        boolean ret = true;
        String cui = this.getCUI();
        if (!Str.compareStr(cui, comp.getCUI())) {
            if (out != null) {
                out.println("this->CUI='" + cui + "' is different from '" + comp.getCUI() + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!Str.compareStr(CompareUtil.logicalEquivCN(cn = this.getCN()), CompareUtil.logicalEquivCN(comp.getCN()))) {
            if (out != null) {
                out.println("this->CN='" + cn + "' is different from '" + comp.getCN() + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        TermVector tv = this.terms;
        TermVector ctv = (TermVector)comp.getTerms();
        if (tv == null && ctv != null || tv != null && ctv == null) {
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (tv == null && ctv == null) {
            return ret;
        }
        if (equalsFlag) {
            if (tv != null && !tv.equals(ctv, out)) {
                if (out != null) {
                    out.println("this->terms are different from the comparison instance");
                }
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
        } else if (tv != null && !tv.equivalent(ctv, out)) {
            if (out != null) {
                out.println("this->terms are different from the comparison instance");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        DefinitionVector dv = this.defs;
        DefinitionVector cdv = (DefinitionVector)comp.getDefs();
        if (dv == null && cdv != null || dv != null && cdv == null) {
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (dv == null && cdv == null) {
            return ret;
        }
        if (equalsFlag) {
            if (dv != null && !dv.equals(cdv, out)) {
                if (out != null) {
                    out.println("this->definitions are different from the comparison instance");
                }
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
        } else if (dv != null && !dv.equivalent(cdv, out)) {
            if (out != null) {
                out.println("this->definitions are different from the comparison instance");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        SemTypeVector sv = this.stys;
        SemTypeVector csv = (SemTypeVector)comp.getSTYs();
        if (sv == null && csv != null || sv != null && csv == null) {
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (sv == null && csv == null) {
            return ret;
        }
        if (equalsFlag) {
            if (sv != null && !sv.equals(csv, out)) {
                if (out != null) {
                    out.println("this->semanticTypes are different from the comparison instance");
                }
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
        } else if (sv != null && !sv.equivalent(csv, out)) {
            if (out != null) {
                out.println("this->semanticTypes are different from the comparison instance");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        ContextVector cxv = this.cxts;
        ContextVector ccxv = (ContextVector)comp.getCXTs();
        if (cxv == null && ccxv != null || cxv != null && ccxv == null) {
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (cxv == null && ccxv == null) {
            return ret;
        }
        if (equalsFlag) {
            if (cxv != null && !cxv.equals(ccxv, out)) {
                if (out != null) {
                    out.println("this->contexts are different from the comparison instance");
                }
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
        } else if (cxv != null && !cxv.equivalent(ccxv, out)) {
            if (out != null) {
                out.println("this->contexts are different from the comparison instance");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        RelationVector rv = this.rels;
        RelationVector crv = (RelationVector)comp.getRels();
        if (rv == null && crv != null || rv != null && crv == null) {
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (rv == null && crv == null) {
            return ret;
        }
        if (equalsFlag) {
            if (rv != null && !rv.equals(crv, out)) {
                if (out != null) {
                    out.println("this->relations are different from the comparison instance");
                }
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
        } else if (rv != null && !rv.equivalent(crv, out)) {
            if (out != null) {
                out.println("this->relations are different from the comparison instance");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        CooccurrenceVector cov = this.cocs;
        CooccurrenceVector ccov = (CooccurrenceVector)comp.getCOCs();
        if (cov == null && ccov != null || cov != null && ccov == null) {
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (cov == null && ccov == null) {
            return ret;
        }
        if (equalsFlag) {
            if (cov != null && !cov.equals(ccov, out)) {
                if (out != null) {
                    out.println("this->cooccurrences are different from the comparison instance");
                }
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
        } else if (cov != null && !cov.equivalent(ccov, out)) {
            if (out != null) {
                out.println("this->cooccurrences are different from the comparison instance");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        TermAttributeVector sa = this.sats;
        TermAttributeVector csa = (TermAttributeVector)comp.getSATs();
        if (sa == null && csa != null || sa != null && csa == null) {
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (sa == null && csa == null) {
            return ret;
        }
        if (equalsFlag) {
            if (sa != null && !sa.equals(csa, out)) {
                if (out != null) {
                    out.println("this->stringAttributes are different from the comparison instance");
                }
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
        } else if (sa != null && !sa.equivalent(csa, out)) {
            if (out != null) {
                out.println("this->stringAttributes are different from the comparison instance");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        AssociatedExpVector ae = this.atxs;
        AssociatedExpVector cae = (AssociatedExpVector)comp.getATXs();
        if (ae == null && cae != null || ae != null && cae == null) {
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (ae == null && cae == null) {
            return ret;
        }
        if (equalsFlag) {
            if (ae != null && !ae.equals(cae, out)) {
                if (out != null) {
                    out.println("this->associatedExprs are different from the comparison instance");
                }
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
        } else if (ae != null && !ae.equivalent(cae, out)) {
            if (out != null) {
                out.println("this->associatedExprs are different from the comparison instance");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        LocatorVector lo = this.locs;
        LocatorVector clo = (LocatorVector)comp.getLOCs();
        if (lo == null && clo != null || lo != null && clo == null) {
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (lo == null && clo == null) {
            return ret;
        }
        if (equalsFlag) {
            if (lo != null && !lo.equals(clo, out)) {
                if (out != null) {
                    out.println("this->locators are different from the comparison instance");
                }
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
        } else if (lo != null && !lo.equivalent(clo, out)) {
            if (out != null) {
                out.println("this->locators are different from the comparison instance");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        return ret;
    }

    public String getKey() {
        return this.cui + this.cn;
    }
}

