/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.meta.concept.Concept;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class ConceptVector
extends KSVector {
    public static final String XmlName = "MetaCollection";
    public static final String XmlStructure = "1.0";

    public ConceptVector(Vector concepts) {
        super(concepts, XmlName, XmlStructure);
    }

    public ConceptVector(ConceptVector concepts) {
        super(concepts, XmlName, XmlStructure);
    }

    public ConceptVector() {
        super(XmlName, XmlStructure);
    }

    public ConceptVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        String childName = "concept";
        List concepts = root.getChildren(childName, namespace);
        if (concepts == null || concepts.size() == 0) {
            return;
        }
        int i = 0;
        while (i < concepts.size()) {
            Element con = (Element)concepts.get(i);
            Concept concept = new Concept(con, namespace);
            if (concept == null) {
                throw new XMLException("Invalid concept definition");
            }
            this.add(concept);
            ++i;
        }
    }

    public static ConceptVector getInstance(String xml) {
        ConceptVector cv = null;
        try {
            cv = new ConceptVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return cv;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.concept.ConceptVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            ConceptVector vec = ConceptVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No concepts read");
                return;
            }
            System.out.println("Release Year: " + vec.getRelease());
            System.out.println("Number of concepts: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                Concept con = (Concept)iter.next();
                System.out.println("Concept----------------");
                con.output();
                System.out.println("Concept END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

