/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSCuiVector;
import gov.nih.nlm.kss.models.meta.concept.SemType;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class SemTypeVector
extends KSCuiVector {
    public static final String XmlName = "SemanticTypeCollection";
    public static final String XmlStructure = "1.0";

    public SemTypeVector() {
        super(XmlName, XmlStructure);
    }

    public SemTypeVector(Vector vector) {
        super(vector, XmlName, XmlStructure);
    }

    public SemTypeVector(SemTypeVector vector) {
        super(vector, XmlName, XmlStructure);
    }

    public SemTypeVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        super.parse(root, namespace);
        String childName = "semanticType";
        List stys = root.getChildren(childName, namespace);
        if (stys == null || stys.size() == 0) {
            return;
        }
        int i = 0;
        while (i < stys.size()) {
            Element styEle = (Element)stys.get(i);
            SemType sty = new SemType(styEle, namespace);
            if (sty == null) {
                throw new XMLException("Invalid semantic type definition");
            }
            this.add(sty);
            ++i;
        }
    }

    public static SemTypeVector getInstance(String xml) {
        SemTypeVector cv = null;
        try {
            cv = new SemTypeVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return cv;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.concept.SemTypeVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            SemTypeVector vec = SemTypeVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No semantic types read");
                return;
            }
            System.out.println("Number of semantic types: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                SemType semtype = (SemType)iter.next();
                System.out.println("SemType----------------");
                semtype.output();
                System.out.println("SemType END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

