/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.concept.StringSource;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class StringId
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private String sui;
    private String stringName;
    private String language;
    private Vector stringSources;
    public static final String XmlName = "stringId";
    private boolean performance = false;

    public StringId() {
        this.sui = "";
        this.stringName = "";
        this.language = "";
        this.stringSources = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public StringId(String sui, String stringName) {
        this.sui = sui;
        this.stringName = stringName;
        this.language = "";
        this.stringSources = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public StringId(String sui, String stringName, Vector stringSources) {
        this.sui = sui;
        this.stringName = stringName;
        this.language = "";
        this.stringSources = stringSources;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public StringId(Element string, Namespace namespace) throws XMLException {
        Element suiChild = string.getChild("sui", namespace);
        if (suiChild == null) {
            throw new XMLException("No lexical/string unique identifier found");
        }
        this.sui = XMLInterpreter.extractString(suiChild);
        Element strChild = string.getChild("string", namespace);
        if (strChild == null) {
            throw new XMLException("No string found");
        }
        this.stringName = XMLInterpreter.extractString(strChild);
        Element latChild = string.getChild("lat", namespace);
        this.language = latChild != null ? XMLInterpreter.extractString(latChild) : "";
        Element srcsChild = string.getChild("sources", namespace);
        if (srcsChild != null) {
            List strSrcs = srcsChild.getChildren("strSource", namespace);
            if (this.stringSources == null) {
                this.stringSources = new Vector();
            }
            int i = 0;
            while (i < strSrcs.size()) {
                Element ssChild = (Element)strSrcs.get(i);
                StringSource s = new StringSource(ssChild, namespace);
                if (s == null) {
                    throw new XMLException("Unable to parse string source\n");
                }
                this.stringSources.add(s);
                ++i;
            }
        }
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public static StringId getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("stringId must be  the name of the first element");
            }
            return new StringId(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setSUI(String sui) {
        this.sui = sui;
    }

    public String getSUI() {
        return this.sui;
    }

    public void setString(String str) {
        this.stringName = str;
    }

    public String getString() {
        return this.stringName;
    }

    public void setLAT(String lat) {
        this.language = lat;
    }

    public String getLAT() {
        return this.language;
    }

    public void setStringSources(Vector strSources) {
        if (strSources == null) {
            this.stringSources = null;
            return;
        }
        this.stringSources = new Vector();
    }

    public void addStringSource(StringSource strSource) {
        if (strSource == null) {
            return;
        }
        if (this.stringSources == null) {
            this.stringSources = new Vector();
        }
        this.stringSources.add(strSource);
    }

    public Vector getStringSources() {
        return this.stringSources;
    }

    public String toString() {
        return this.xmlize();
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("SUI:      " + this.sui);
        out.println("String:     " + this.stringName);
        out.println("Language:   " + this.language);
        if (this.stringSources != null) {
            Iterator iter = this.stringSources.iterator();
            while (iter.hasNext()) {
                ((StringSource)iter.next()).output();
            }
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "   ";
        String tab = "      ";
        xml.ensureCapacity(xml.length() + 380);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.append("<sui>");
        xml.append(this.sui);
        xml.append("</sui>\n");
        xml.append(tab);
        xml.append("<string>");
        xml.append(Str.escape(this.getString()));
        xml.append("</string>\n");
        if (this.language != null && !this.language.equals("")) {
            xml.append(tab);
            xml.append("<lat>");
            xml.append(Str.escape(this.getLAT()));
            xml.append("</lat>\n");
        }
        if (this.stringSources != null && this.stringSources.size() > 0) {
            xml.append(tab);
            xml.append("<sources>\n");
            Iterator iter = this.stringSources.iterator();
            while (iter.hasNext()) {
                xml.append(((StringSource)iter.next()).xmlize());
            }
            xml.append(tab);
            xml.append("</sources>\n");
        }
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String lat;
        String stringName;
        if (!(c instanceof StringId)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        StringId comp = (StringId)c;
        boolean ret = true;
        String sui = this.getSUI();
        if (!Str.compareStr(sui, comp.getSUI())) {
            if (out != null) {
                out.println("this->SUI='" + sui + "' is different from '" + comp.getSUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(stringName = this.getString(), comp.getString())) {
            if (out != null) {
                out.println("this->stringName='" + stringName + "' different from '" + comp.getString() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(lat = this.getLAT(), comp.getLAT())) {
            if (out != null) {
                out.println("this->language='" + lat + "' different from '" + comp.getLAT() + "'");
            }
            ret = false;
        }
        if (this.stringSources == null && comp.getStringSources() == null) {
            return ret;
        }
        if (this.stringSources == null && comp.getStringSources() != null || this.stringSources != null && comp.getStringSources() == null) {
            return false;
        }
        return ret & StringId.compareSources(this.getStringSources(), comp.getStringSources(), out, equalsFlag, this.performance);
    }

    private static boolean compareSources(Vector thisVec, Vector compVec, PrintStream out, boolean equalsFlag, boolean performance) {
        boolean ret = true;
        Hashtable compht = StringId.convert(compVec);
        Hashtable thisht = StringId.convert(thisVec);
        Enumeration compkeys = compht.keys();
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            StringSource val = (StringSource)thisht.get(compkey);
            if (val == null) {
                if (out != null) {
                    StringSource missing = (StringSource)compht.get(compkey);
                    out.println("StringSource missing from this instance:");
                    out.println(missing.xmlize());
                }
                ret = false;
                if (!performance) continue;
                return ret;
            }
            StringSource val2 = (StringSource)compht.get(compkey);
            if (equalsFlag) {
                if (!val.equals(val2, out)) {
                    ret = false;
                    if (performance) {
                        return ret;
                    }
                }
            } else if (!val.equivalent(val2, out)) {
                ret = false;
                if (performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            StringSource val = (StringSource)thisht.get(thiskey);
            if (out == null) continue;
            StringSource added = (StringSource)thisht.get(thiskey);
            out.println("StringSource added to this instance:");
            out.println(added.xmlize());
        }
        return ret;
    }

    private static Hashtable convert(Vector vector) {
        Hashtable<String, StringSource> table = new Hashtable<String, StringSource>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            StringSource val = (StringSource)iter.next();
            table.put(val.getKey(), val);
        }
        return table;
    }

    public String getKey() {
        return this.sui + this.language;
    }
}

