/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.concept.StringSource;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class StringInfo
extends XMLInterpreter
implements Serializable,
KSComparable,
Xmlizable {
    private String sui;
    private String stt;
    private String str;
    private Vector ss;
    private boolean performance = false;
    public static final String XmlName = "termVariant";

    public StringInfo() {
        this.sui = "";
        this.stt = "";
        this.str = "";
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public StringInfo(String sui, String stt, String str) {
        this.sui = sui;
        this.stt = stt;
        this.str = str;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public StringInfo(Element info, Namespace namespace) throws XMLException {
        Element suiChild;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        if ((suiChild = info.getChild("sui", namespace)) == null) {
            throw new XMLException("No string unique identifier <sui> found");
        }
        this.sui = XMLInterpreter.extractString(suiChild);
        Element sttChild = info.getChild("stt", namespace);
        if (sttChild == null) {
            throw new XMLException("No string term type <stt> found");
        }
        this.stt = XMLInterpreter.extractString(sttChild);
        Element strChild = info.getChild("str", namespace);
        if (strChild == null) {
            throw new XMLException("No string value <str> found");
        }
        this.str = XMLInterpreter.extractString(strChild);
        List srcs = info.getChildren("strSource", namespace);
        this.processSources(srcs, namespace);
    }

    private void processSources(List sources, Namespace namespace) throws XMLException {
        Vector<StringSource> vec = new Vector<StringSource>();
        int i = 0;
        while (i < sources.size()) {
            Element varElement = (Element)sources.get(i);
            StringSource t = new StringSource(varElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse string source\n");
            }
            vec.add(t);
            ++i;
        }
        this.setSS(vec);
    }

    public static StringInfo getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("termVariant must be the name of the first element");
            }
            return new StringInfo(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setSS(Vector stringSources) {
        this.ss = stringSources;
    }

    public void addSS(StringSource stringSource) {
        if (this.ss == null) {
            this.ss = new Vector();
        }
        this.ss.add(stringSource);
    }

    public Vector getSS() {
        return this.ss;
    }

    public void setSUI(String sui) {
        this.sui = sui;
    }

    public String getSUI() {
        return this.sui;
    }

    public void setSTT(String stt) {
        this.stt = stt;
    }

    public String getSTT() {
        return this.stt;
    }

    public void setSTR(String str) {
        this.str = str;
    }

    public String getSTR() {
        return this.str;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        String varTab = "      ";
        out.println(varTab + "SUI:     " + this.sui);
        out.println(varTab + "STT:     " + this.stt);
        out.println(varTab + "Name:    " + this.str);
        out.println(varTab + "Sources: ");
        Vector sourceList = this.getSS();
        if (sourceList != null) {
            Iterator vIter4 = sourceList.iterator();
            while (vIter4.hasNext()) {
                ((StringSource)vIter4.next()).output();
            }
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(3000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "         ";
        String tab1 = "            ";
        xml.ensureCapacity(xml.length() + 400);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab1);
        xml.append("<sui>");
        xml.append(this.sui);
        xml.append("</sui>\n");
        xml.append(tab1);
        xml.append("<stt>");
        xml.append(this.stt);
        xml.append("</stt>\n");
        xml.append(tab1);
        xml.append("<str>");
        xml.append(Str.escape(this.str));
        xml.append("</str>\n");
        if (this.ss != null) {
            Iterator vIter4 = this.ss.iterator();
            while (vIter4.hasNext()) {
                ((StringSource)vIter4.next()).xmlize(xml);
            }
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof StringInfo)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        StringInfo comp = (StringInfo)c;
        boolean ret = true;
        String cval = comp.getSUI();
        if (!Str.compareStr(this.sui, cval)) {
            if (out != null) {
                out.println("this->sui='" + this.sui + "' is different from '" + cval + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!Str.compareStr(this.stt, cval = comp.getSTT())) {
            if (out != null) {
                out.println("this->stt='" + this.stt + "' is different from '" + cval + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!Str.compareStr(this.str, cval = comp.getSTR())) {
            if (out != null) {
                out.println("this->str='" + this.str + "' is different from '" + cval + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Vector srcs = comp.getSS();
        if (this.ss == null && srcs != null || this.ss != null && srcs == null) {
            if (out != null) {
                out.println("StringSources are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (this.ss == null && srcs == null) {
            return ret;
        }
        if (this.ss.size() != srcs.size()) {
            if (out != null) {
                out.println("StringSources are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Hashtable compht = this.convert(srcs);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(this.ss);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            StringSource val = (StringSource)thisht.get(compkey);
            if (val == null) {
                if (out != null) {
                    StringSource missing = (StringSource)compht.get(compkey);
                    out.println("StringSource missing from this instance:");
                    out.println(missing.xmlize());
                }
                ret = false;
                if (!this.performance) continue;
                return ret;
            }
            StringSource val2 = (StringSource)compht.get(compkey);
            if (equalsFlag) {
                if (!val.equals(val2, out)) {
                    ret = false;
                    if (this.performance) {
                        return ret;
                    }
                }
            } else if (!val.equivalent(val2, out)) {
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (this.performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            StringSource val = (StringSource)thisht.get(thiskey);
            if (out == null) continue;
            StringSource added = (StringSource)thisht.get(thiskey);
            out.println("StringSource added to this instance:");
            out.println(added.xmlize());
        }
        return ret;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, StringSource> table = new Hashtable<String, StringSource>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            StringSource val = (StringSource)iter.next();
            table.put(val.getKey(), val);
        }
        return table;
    }

    public String getKey() {
        return this.sui;
    }
}

