/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.concept.SourceInfo;
import gov.nih.nlm.kss.util.CompareUtil;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class StringSource
extends XMLInterpreter
implements Serializable,
KSComparable,
Xmlizable {
    private String sab;
    private String scd;
    private String srl;
    private Vector srcInfos;
    private boolean performance = false;
    public static final String XmlName = "strSource";

    public StringSource() {
        this.sab = "";
        this.scd = "";
        this.srl = "";
    }

    public StringSource(StringSource src) {
        this.sab = src.getSAB();
        this.scd = src.getSCD();
        this.srl = src.getSRL();
        this.srcInfos = new Vector();
        Iterator iter = src.getSrcInfos().iterator();
        while (iter.hasNext()) {
            SourceInfo s = (SourceInfo)iter.next();
            this.srcInfos.add(new SourceInfo(s));
        }
    }

    public StringSource(String sab, String tty, String scd, String srl) {
        this.sab = sab;
        this.scd = scd;
        this.srl = srl;
    }

    public StringSource(Element source, Namespace namespace) throws XMLException {
        Element suppChild;
        Element sabChild = source.getChild("sab", namespace);
        if (sabChild == null) {
            throw new XMLException("No source abbreviation <sab> found");
        }
        this.sab = XMLInterpreter.extractString(sabChild);
        Element scdChild = source.getChild("scd", namespace);
        this.scd = scdChild == null ? "" : XMLInterpreter.extractString(scdChild);
        Element srlChild = source.getChild("srl", namespace);
        if (srlChild == null) {
            throw new XMLException("No source restriction level <srl> found");
        }
        this.srl = XMLInterpreter.extractString(srlChild);
        SourceInfo info = null;
        Element ttyChild = source.getChild("tty", namespace);
        if (ttyChild != null) {
            String tty = XMLInterpreter.extractString(ttyChild);
            info = new SourceInfo();
            info.setTTY(tty);
        }
        if ((suppChild = source.getChild("suppressible", namespace)) != null) {
            if (info == null) {
                info = new SourceInfo();
            }
            info.setSuppressible(true);
        }
        List srcIs = source.getChildren("srcinfo", namespace);
        this.processInfos(srcIs, namespace);
        if (info != null) {
            this.addSrcInfo(info);
        }
    }

    private void processInfos(List info, Namespace namespace) throws XMLException {
        Vector<SourceInfo> vec = new Vector<SourceInfo>();
        int i = 0;
        while (i < info.size()) {
            Element varElement = (Element)info.get(i);
            SourceInfo t = new SourceInfo(varElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse source info\n");
            }
            vec.add(t);
            ++i;
        }
        this.setSrcInfos(vec);
    }

    public static StringSource getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("strSource must be the name of the first element");
            }
            return new StringSource(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setSAB(String sab) {
        this.sab = sab;
    }

    public String getSAB() {
        return this.sab;
    }

    public void setTTY(String tty) {
    }

    public String getTTY() {
        return null;
    }

    public void setSCD(String scd) {
        this.scd = scd;
    }

    public String getSCD() {
        return this.scd;
    }

    public void setSRL(String srl) {
        this.srl = srl;
    }

    public String getSRL() {
        return this.srl;
    }

    public void setSuppressible(boolean suppressible) {
    }

    public boolean getSuppressible() {
        return true;
    }

    public void setSrcInfos(Vector srcInfos) {
        this.srcInfos = srcInfos;
    }

    public void addSrcInfo(SourceInfo srcinfo) {
        if (this.srcInfos == null) {
            this.srcInfos = new Vector();
        }
        this.srcInfos.add(srcinfo);
    }

    public Vector getSrcInfos() {
        return this.srcInfos;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        String soTab = "         ";
        out.println(soTab + "SAB:    " + this.sab);
        out.println(soTab + "SCD:    " + this.scd);
        out.println(soTab + "SRL:    " + this.srl);
        Iterator iter = this.srcInfos.iterator();
        while (iter.hasNext()) {
            SourceInfo info = (SourceInfo)iter.next();
            info.output();
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(100000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "          ";
        String tab1 = "             ";
        xml.ensureCapacity(xml.length() + 200);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        if (this.sab != null) {
            xml.append(tab1);
            xml.append("<sab>");
            xml.append(this.sab);
            xml.append("</sab>\n");
        }
        if (this.scd != null) {
            xml.append(tab1);
            xml.append("<scd>");
            xml.append(Str.escape(this.scd));
            xml.append("</scd>\n");
        }
        if (this.srl != null) {
            xml.append(tab1);
            xml.append("<srl>");
            xml.append(this.srl);
            xml.append("</srl>\n");
        }
        Iterator iter = this.srcInfos.iterator();
        while (iter.hasNext()) {
            xml.append(((SourceInfo)iter.next()).xmlize());
        }
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String str;
        if (!(c instanceof StringSource)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        StringSource comp = (StringSource)c;
        boolean ret = true;
        String csab = comp.getSAB();
        String lsab = this.sab;
        if (!equalsFlag) {
            csab = CompareUtil.logicalEquivSAB(csab);
            lsab = CompareUtil.logicalEquivSAB(lsab);
        }
        if (!Str.compareStr(lsab, csab)) {
            if (out != null) {
                out.println("this->SAB='" + this.sab + "' is different from '" + comp.getSAB() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.scd, str = comp.getSCD())) {
            if (out != null) {
                out.println("this->SCD='" + this.scd + "' different from '" + str + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.srl, str = comp.getSRL())) {
            if (out != null) {
                out.println("this->SRL='" + this.srl + "' different from '" + str + "'");
            }
            ret = false;
        }
        Vector infos = comp.getSrcInfos();
        if (this.srcInfos == null && infos != null || this.srcInfos != null && infos == null) {
            if (out != null) {
                out.println("SourceInfos are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (this.srcInfos == null && infos == null) {
            return ret;
        }
        if (this.srcInfos.size() != infos.size()) {
            if (out != null) {
                out.println("SourceInfos are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Hashtable compht = this.convert(infos);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(this.srcInfos);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            SourceInfo val = (SourceInfo)thisht.get(compkey);
            if (val == null) {
                if (out != null) {
                    SourceInfo missing = (SourceInfo)compht.get(compkey);
                    out.println("SourceInfo missing from this instance:");
                    out.println(missing.xmlize());
                }
                ret = false;
                if (!this.performance) continue;
                return ret;
            }
            SourceInfo val2 = (SourceInfo)compht.get(compkey);
            if (equalsFlag) {
                if (!val.equals(val2, out)) {
                    ret = false;
                    if (this.performance) {
                        return ret;
                    }
                }
            } else if (!val.equivalent(val2, out)) {
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (this.performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            SourceInfo val = (SourceInfo)thisht.get(thiskey);
            if (out == null) continue;
            SourceInfo added = (SourceInfo)thisht.get(thiskey);
            out.println("SourceInfo added to this instance:");
            out.println(added.xmlize());
        }
        return ret;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, SourceInfo> table = new Hashtable<String, SourceInfo>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            SourceInfo val = (SourceInfo)iter.next();
            table.put(val.getKey(), val);
        }
        return table;
    }

    public String getKey() {
        return CompareUtil.logicalEquivSAB(this.sab) + this.scd + this.srl;
    }
}

