/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.concept.StringInfo;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class Term
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    public static final String XmlName = "term";
    private String lui;
    private String tn;
    private String ts;
    private String lat;
    private Vector tv;
    private boolean preferred;
    private boolean performance = false;

    public Term() {
        this.lui = "";
        this.ts = "";
        this.lat = "";
        this.preferred = false;
        this.tv = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public Term(String lui, String ts, String lat) {
        this.lui = lui;
        this.ts = ts;
        this.lat = lat;
        this.preferred = false;
        this.tv = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public Term(Term term) {
        this.lui = term.getLUI();
        this.tn = term.getTN();
        this.ts = term.getTS();
        this.lat = term.getLAT();
        if (term.getTV() != null) {
            this.tv = new Vector(term.getTV());
        }
        this.preferred = term.getPreferred();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public Term(Element term, Namespace namespace) throws XMLException {
        Element luiChild;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        if ((luiChild = term.getChild("lui", namespace)) == null) {
            throw new XMLException("No lexical unique identifier <lui> found");
        }
        this.lui = XMLInterpreter.extractString(luiChild);
        Element tnChild = term.getChild("tn", namespace);
        if (tnChild == null) {
            throw new XMLException("No term name <tn> found");
        }
        this.tn = XMLInterpreter.extractString(tnChild);
        Element tsChild = term.getChild("ts", namespace);
        if (tsChild == null) {
            throw new XMLException("No term status value <ts> found");
        }
        this.ts = XMLInterpreter.extractString(tsChild);
        Element latChild = term.getChild("lat", namespace);
        if (latChild == null) {
            throw new XMLException("No term language <lat> found");
        }
        this.lat = XMLInterpreter.extractString(latChild);
        List vars = term.getChildren("termVariant", namespace);
        this.processVariants(vars, namespace);
    }

    private void processVariants(List variants, Namespace namespace) throws XMLException {
        Vector<StringInfo> vec = new Vector<StringInfo>();
        int i = 0;
        while (i < variants.size()) {
            Element varElement = (Element)variants.get(i);
            StringInfo t = new StringInfo(varElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse string variant\n");
            }
            vec.add(t);
            ++i;
        }
        this.setTV(vec);
    }

    public static Term getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("term must be the name of the first element");
            }
            return new Term(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setTN(String tn) {
        this.tn = tn;
    }

    public void setLUI(String lui) {
        this.lui = lui;
    }

    public String getLUI() {
        return this.lui;
    }

    public void setTS(String ts) {
        this.ts = ts;
    }

    public String getTS() {
        return this.ts;
    }

    public void setLAT(String lat) {
        this.lat = lat;
    }

    public String getLAT() {
        return this.lat;
    }

    public void setTV(Vector tv) {
        this.tv = tv;
    }

    public void addTV(StringInfo variant) {
        if (this.tv == null) {
            this.tv = new Vector();
        }
        this.tv.addElement(variant);
    }

    public String getTN() {
        return this.tn;
    }

    public Vector getTV() {
        return this.tv;
    }

    public boolean getPreferred() {
        return this.preferred;
    }

    public void setPreferred(boolean pref) {
        this.preferred = pref;
    }

    public StringInfo getStringInfo(String sui) {
        Vector variantList = this.getTV();
        Iterator vIter3 = variantList.iterator();
        while (vIter3.hasNext()) {
            StringInfo variant = (StringInfo)vIter3.next();
            if (!variant.getSUI().equals(sui)) continue;
            return variant;
        }
        System.out.println("Term:getStringInfo: no string for sui:" + sui);
        return null;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        String tab = "   ";
        out.println(tab + "LUI:      " + this.lui);
        out.println(tab + "Name:     " + this.tn);
        out.println(tab + "Status:   " + this.ts);
        out.println(tab + "Language: " + this.lat);
        out.println(tab + "Variants: ");
        Vector variantList = this.getTV();
        Iterator vIter3 = variantList.iterator();
        while (vIter3.hasNext()) {
            StringInfo variant = (StringInfo)vIter3.next();
            variant.output();
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(10000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "      ";
        String tab = "         ";
        xml.ensureCapacity(xml.length() + 400);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.append("<lui>");
        xml.append(this.lui);
        xml.append("</lui>\n");
        xml.append(tab);
        xml.append("<tn>");
        xml.append(Str.escape(this.tn));
        xml.append("</tn>\n");
        xml.append(tab);
        xml.append("<ts>");
        xml.append(this.ts);
        xml.append("</ts>\n");
        xml.append(tab);
        xml.append("<lat>");
        xml.append(this.lat);
        xml.append("</lat>\n");
        Vector vars = this.getTV();
        if (vars != null) {
            Iterator vIter3 = vars.iterator();
            while (vIter3.hasNext()) {
                StringInfo variant = (StringInfo)vIter3.next();
                variant.xmlize(xml);
            }
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String lat;
        String ts;
        String tn;
        if (!(c instanceof Term)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        Term comp = (Term)c;
        boolean ret = true;
        String lui = this.getLUI();
        if (!Str.compareStr(lui, comp.getLUI())) {
            if (out != null) {
                out.println("this->LUI='" + lui + "' is different from '" + comp.getLUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(tn = this.getTN(), comp.getTN())) {
            if (out != null) {
                out.println("this->TN='" + tn + "' is different from '" + comp.getTN() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(ts = this.getTS(), comp.getTS())) {
            if (out != null) {
                out.println("this->TS='" + ts + "' is different from '" + comp.getTS() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(lat = this.getLAT(), comp.getLAT())) {
            if (out != null) {
                out.println("this->LAT='" + lat + "' is different from '" + comp.getLAT() + "'");
            }
            ret = false;
        }
        Vector vars = comp.getTV();
        if (this.tv == null && vars != null || this.tv != null && vars == null) {
            if (out != null) {
                out.println("TermVariants are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (this.tv == null && vars == null) {
            return ret;
        }
        if (this.tv == null && vars != null || this.tv != null && vars == null) {
            return false;
        }
        if (this.tv.size() != vars.size()) {
            if (out != null) {
                out.println("TermVariants are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Hashtable compht = this.convert(vars);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(this.tv);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            StringInfo val = (StringInfo)thisht.get(compkey);
            if (val == null) {
                if (out != null) {
                    StringInfo missing = (StringInfo)compht.get(compkey);
                    out.println("StringInfo missing from this instance:");
                    out.println(missing.xmlize());
                }
                ret = false;
                if (!this.performance) continue;
                return ret;
            }
            StringInfo val2 = (StringInfo)compht.get(compkey);
            if (equalsFlag) {
                if (!val.equals(val2, out)) {
                    ret = false;
                    if (this.performance) {
                        return ret;
                    }
                }
            } else if (!val.equivalent(val2, out)) {
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (this.performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            StringInfo val = (StringInfo)thisht.get(thiskey);
            if (out == null) continue;
            StringInfo added = (StringInfo)thisht.get(thiskey);
            out.println("StringInfo added to this instance:");
            out.println(added.xmlize());
        }
        return ret;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, StringInfo> table = new Hashtable<String, StringInfo>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            StringInfo exp = (StringInfo)iter.next();
            table.put(exp.getKey(), exp);
        }
        return table;
    }

    public String getKey() {
        return this.lui;
    }
}

