/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.meta.concept.TermVector;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class TermCollection
extends KSVector {
    public static final String XmlName = "TermCollection";
    public static final String XmlStructure = "1.0";

    public TermCollection(Vector termCol) {
        super(termCol, XmlName, XmlStructure);
    }

    public TermCollection(TermCollection termCol) {
        super(termCol, XmlName, XmlStructure);
    }

    public TermCollection() {
        super(XmlName, XmlStructure);
    }

    public TermCollection(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        String childName = "termList";
        List terms = root.getChildren(childName, namespace);
        if (terms == null || terms.size() == 0) {
            return;
        }
        int i = 0;
        while (i < terms.size()) {
            Element termEle = (Element)terms.get(i);
            TermVector term = new TermVector(termEle, namespace);
            if (term == null) {
                throw new XMLException("Invalid term list definition");
            }
            this.add(term);
            ++i;
        }
    }

    public static TermCollection getInstance(String xml) {
        TermCollection cv = null;
        try {
            cv = new TermCollection(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return cv;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java gov.nih.nlm.kss.models.meta.");
            System.out.print("concept.TermCollection");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            TermCollection vec = TermCollection.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No term vectors read");
                return;
            }
            System.out.println("Number of term vectors: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                TermVector term = (TermVector)iter.next();
                System.out.println("TermVector----------------");
                term.output();
                System.out.println("TermVector END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

