/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.concept.StringSource;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class TermId
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private String lui;
    private String termName;
    private String lat;
    private Vector stringSources;
    public static final String XmlName = "termId";
    private boolean performance = false;

    public TermId() {
        this.lui = "";
        this.termName = "";
        this.lat = "";
        this.stringSources = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public TermId(String lui, String termName) {
        this.lui = lui;
        this.termName = termName;
        this.lat = "";
        this.stringSources = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public TermId(String lui, String termName, Vector stringSources) {
        this.lui = lui;
        this.termName = termName;
        this.lat = "";
        this.stringSources = stringSources;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public TermId(String lui, String termName, String lat, Vector stringSources) {
        this.lui = lui;
        this.termName = termName;
        this.lat = lat;
        this.stringSources = stringSources;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public TermId(Element term, Namespace namespace) throws XMLException {
        Element luiChild = term.getChild("lui", namespace);
        if (luiChild == null) {
            throw new XMLException("No lexical/term unique identifier found");
        }
        this.lui = XMLInterpreter.extractString(luiChild);
        Element tnChild = term.getChild("termName", namespace);
        if (tnChild == null) {
            throw new XMLException("No term name found");
        }
        this.termName = XMLInterpreter.extractString(tnChild);
        Element latChild = term.getChild("lat", namespace);
        this.lat = latChild != null ? XMLInterpreter.extractString(latChild) : "";
        Element srcsChild = term.getChild("sources", namespace);
        if (srcsChild != null) {
            List strSrcs = srcsChild.getChildren("strSource", namespace);
            if (this.stringSources == null) {
                this.stringSources = new Vector();
            }
            int i = 0;
            while (i < strSrcs.size()) {
                Element ssChild = (Element)strSrcs.get(i);
                StringSource s = new StringSource(ssChild, namespace);
                if (s == null) {
                    throw new XMLException("Unable to parse string source\n");
                }
                this.stringSources.add(s);
                ++i;
            }
        }
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public static TermId getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("termId must be  the name of the first element");
            }
            return new TermId(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setLUI(String lui) {
        this.lui = lui;
    }

    public String getLUI() {
        return this.lui;
    }

    public void setTermName(String tn) {
        this.termName = tn;
    }

    public String getTermName() {
        return this.termName;
    }

    public void setLAT(String lat) {
        this.lat = lat;
    }

    public String getLAT() {
        return this.lat;
    }

    public void setStringSources(Vector strSources) {
        if (strSources == null) {
            this.stringSources = null;
            return;
        }
        this.stringSources = new Vector();
    }

    public void addStringSource(StringSource strSource) {
        if (this.stringSources == null) {
            this.stringSources = new Vector();
        }
        this.stringSources.addElement(strSource);
    }

    public Vector getStringSources() {
        return this.stringSources;
    }

    public String toString() {
        return this.xmlize();
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("LUI:      " + this.lui);
        out.println("Name:     " + this.termName);
        out.println("Language: " + this.lat);
        if (this.stringSources != null) {
            Iterator iter = this.stringSources.iterator();
            while (iter.hasNext()) {
                ((StringSource)iter.next()).output();
            }
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "   ";
        String tab = "      ";
        xml.ensureCapacity(xml.length() + 380);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.append("<lui>");
        xml.append(this.lui);
        xml.append("</lui>\n");
        xml.append(tab);
        xml.append("<termName>");
        xml.append(Str.escape(this.getTermName()));
        xml.append("</termName>\n");
        if (this.lat != null && !this.lat.equals("")) {
            xml.append(tab);
            xml.append("<lat>");
            xml.append(Str.escape(this.getLAT()));
            xml.append("</lat>\n");
        }
        if (this.stringSources != null && this.stringSources.size() > 0) {
            xml.append(tab);
            xml.append("<sources>\n");
            Iterator iter = this.stringSources.iterator();
            while (iter.hasNext()) {
                xml.append(((StringSource)iter.next()).xmlize());
            }
            xml.append(tab);
            xml.append("</sources>\n");
        }
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String lat;
        String termName;
        if (!(c instanceof TermId)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies:" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        TermId comp = (TermId)c;
        boolean ret = true;
        String lui = this.getLUI();
        if (!Str.compareStr(lui, comp.getLUI())) {
            if (out != null) {
                out.println("this->LUI='" + lui + "' is different from '" + comp.getLUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(termName = this.getTermName(), comp.getTermName())) {
            if (out != null) {
                out.println("this->termName='" + termName + "' different from '" + comp.getTermName() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(lat = this.getLAT(), comp.getLAT())) {
            if (out != null) {
                out.println("this->lat='" + lat + "' different from '" + comp.getLAT() + "'");
            }
            ret = false;
        }
        if (this.stringSources == null && comp.getStringSources() == null) {
            return ret;
        }
        if (this.stringSources == null && comp.getStringSources() != null || this.stringSources != null && comp.getStringSources() == null) {
            return false;
        }
        return ret & TermId.compareSources(this.getStringSources(), comp.getStringSources(), out, equalsFlag, this.performance);
    }

    private static boolean compareSources(Vector thisVec, Vector compVec, PrintStream out, boolean equalsFlag, boolean performance) {
        boolean ret = true;
        Hashtable compht = TermId.convert(compVec);
        Hashtable thisht = TermId.convert(thisVec);
        Enumeration compkeys = compht.keys();
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            StringSource val = (StringSource)thisht.get(compkey);
            if (val == null) {
                if (out != null) {
                    StringSource missing = (StringSource)compht.get(compkey);
                    out.println("StringSource missing from this instance:");
                    out.println(missing.xmlize());
                }
                ret = false;
                if (!performance) continue;
                return ret;
            }
            StringSource val2 = (StringSource)compht.get(compkey);
            if (equalsFlag) {
                if (!val.equals(val2, out)) {
                    ret = false;
                    if (performance) {
                        return ret;
                    }
                }
            } else if (!val.equivalent(val2, out)) {
                ret = false;
                if (performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            StringSource val = (StringSource)thisht.get(thiskey);
            if (out == null) continue;
            StringSource added = (StringSource)thisht.get(thiskey);
            out.println("StringSource added to this instance:");
            out.println(added.xmlize());
        }
        return ret;
    }

    private static Hashtable convert(Vector vector) {
        Hashtable<String, StringSource> table = new Hashtable<String, StringSource>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            StringSource val = (StringSource)iter.next();
            table.put(val.getKey(), val);
        }
        return table;
    }

    public String getKey() {
        return this.lui + this.termName;
    }
}

