/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSCuiVector;
import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.meta.concept.Term;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class TermVector
extends KSCuiVector {
    public static final String XmlName = "termList";
    public static final String XmlStructure = "1.0";

    public TermVector(Vector terms) {
        super(terms, XmlName, XmlStructure);
    }

    public TermVector(TermVector terms) {
        super(terms, XmlName, XmlStructure);
    }

    public TermVector(KSCuiVector terms) {
        super(terms, XmlName, XmlStructure);
    }

    public TermVector(KSVector terms) {
        super((Vector)terms, XmlName, XmlStructure);
    }

    public TermVector() {
        super(XmlName, XmlStructure);
    }

    public TermVector(Element termvec, Namespace namespace) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(termvec, namespace);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        super.parse(root, namespace);
        String childName = "term";
        List terms = root.getChildren(childName, namespace);
        if (terms == null || terms.size() == 0) {
            return;
        }
        int i = 0;
        while (i < terms.size()) {
            Element termEle = (Element)terms.get(i);
            Term term = new Term(termEle, namespace);
            if (term == null) {
                throw new XMLException("Invalid term definition");
            }
            this.add(term);
            ++i;
        }
    }

    public TermVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    public static TermVector getInstance(String xml) {
        TermVector cv = null;
        try {
            cv = new TermVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return cv;
    }

    public String xmlize() {
        return this.xmlize(false);
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        String tab = "   ";
        out.println(tab + "YEAR: " + this.getRelease());
        out.println(tab + "CUI: " + this.getCUI());
        out.println(tab + "CN:  " + this.getCN());
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ((Term)iter.next()).output();
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.concept.TermVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            TermVector vec = TermVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No terms read");
                return;
            }
            System.out.println("Number of terms: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                Term term = (Term)iter.next();
                System.out.println("Term----------------");
                term.output();
                System.out.println("Term END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getKey() {
        return this.getCUI() + this.getCN();
    }
}

