/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.cooccurrence;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.cooccurrence.QualifierFrequency;
import gov.nih.nlm.kss.models.meta.cooccurrence.QualifierFrequencyVector;
import gov.nih.nlm.kss.models.meta.source.Source;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class COContext
extends XMLInterpreter
implements Serializable,
KSComparable,
Xmlizable {
    public static final String XmlName = "source";
    private Source source;
    private String aui2;
    private String cot;
    private int cof;
    private QualifierFrequencyVector qualifiers;
    private boolean performance = false;

    public COContext() {
        this.source = null;
        this.aui2 = "";
        this.cot = "";
        this.cof = 0;
        this.qualifiers = null;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public COContext(Source source, String cot, int cof) {
        this.source = source;
        this.aui2 = "";
        this.cot = cot;
        this.cof = cof;
        this.qualifiers = new QualifierFrequencyVector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public COContext(Source source, String aui2, String cot, int cof) {
        this.source = source;
        this.aui2 = aui2;
        this.cot = cot;
        this.cof = cof;
        this.qualifiers = new QualifierFrequencyVector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public COContext(Element coc, Namespace namespace) throws XMLException {
        Element sabChild;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        if ((sabChild = coc.getChild("sab", namespace)) == null) {
            throw new XMLException("No source abbreviation <sab> found");
        }
        String sab = XMLInterpreter.extractString(sabChild);
        this.source = new Source(sab, "", "");
        Element aui2Child = coc.getChild("aui2", namespace);
        this.aui2 = aui2Child != null ? XMLInterpreter.extractString(aui2Child) : "";
        Element cotChild = coc.getChild("cot", namespace);
        if (cotChild == null) {
            throw new XMLException("No cooccurrence type <cot> found");
        }
        this.cot = XMLInterpreter.extractString(cotChild);
        Element cofChild = coc.getChild("cof", namespace);
        if (cofChild == null) {
            throw new XMLException("No cooccurrence frequency <cof> found");
        }
        String cofstr = XMLInterpreter.extractString(cofChild);
        Integer cofint = new Integer(cofstr);
        this.cof = cofint;
        List qualfreqs = coc.getChildren("qualifiers", namespace);
        int i = 0;
        while (i < qualfreqs.size()) {
            Element qfelem = (Element)qualfreqs.get(i);
            QualifierFrequency t = new QualifierFrequency(qfelem, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse qualifier frequency\n");
            }
            this.addQualifier(t);
            ++i;
        }
    }

    public static COContext getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("source must be the name of the first element");
            }
            return new COContext(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public Source getSource() {
        return this.source;
    }

    public void setAUI2(String aui2) {
        this.aui2 = aui2;
    }

    public String getAUI2() {
        return this.aui2;
    }

    public void setCOT(String cot) {
        this.cot = cot;
    }

    public String getCOT() {
        return this.cot;
    }

    public void setCOF(int cof) {
        this.cof = cof;
    }

    public int getCOF() {
        return this.cof;
    }

    public QualifierFrequencyVector getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(QualifierFrequencyVector qualifiers) {
        this.qualifiers = qualifiers;
    }

    public void addQualifier(QualifierFrequency qualifier) {
        if (this.qualifiers == null) {
            this.qualifiers = new QualifierFrequencyVector();
        }
        this.qualifiers.addElement(qualifier);
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        String tab = "      ";
        out.println("");
        out.println(tab + "Source:     " + this.source.getSAB());
        out.println(tab + "Atom Id:    " + this.getAUI2());
        out.println(tab + "CoType:     " + this.getCOT());
        out.println(tab + "Freq:       " + this.getCOF());
        out.println(tab + "Qualifiers:  ");
        QualifierFrequencyVector quals = this.getQualifiers();
        if (quals == null) {
            return;
        }
        Iterator iter = quals.iterator();
        while (iter.hasNext()) {
            ((QualifierFrequency)iter.next()).output();
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(10000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        COContext.xmlize(xml, this.source.getSAB(), this.getAUI2(), this.getCOT(), this.getCOF(), this.getQualifiers());
    }

    public static void xmlize(StringBuffer xml, String sab, String cot, int cof, QualifierFrequencyVector quals) {
        COContext.xmlize(xml, sab, "", cot, cof, quals);
    }

    private static void xmlize(StringBuffer xml, String sab, String aui2, String cot, int cof, QualifierFrequencyVector quals) {
        String tab0 = "         ";
        String tab = "            ";
        xml.ensureCapacity(xml.length() + 110);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.append("<sab>");
        xml.append(sab);
        xml.append("</sab>\n");
        if (aui2 != null && !aui2.equals("")) {
            xml.append(tab);
            xml.append("<aui2>");
            xml.append(aui2);
            xml.append("</aui2>\n");
        }
        xml.append(tab);
        xml.append("<cot>");
        xml.append(cot);
        xml.append("</cot>\n");
        xml.append(tab);
        xml.append("<cof>");
        xml.append(cof);
        xml.append("</cof>\n");
        if (quals != null) {
            quals.xmlize(xml);
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        int ival;
        String cval;
        if (!(c instanceof COContext)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        COContext comp = (COContext)c;
        boolean ret = true;
        Source sabsrc = comp.getSource();
        if (this.source != null && !this.source.equals(sabsrc, out)) {
            if (out != null) {
                out.println("this->source is different from the comparison source");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!Str.compareStr(this.cot, cval = comp.getCOT())) {
            if (out != null) {
                out.println("this->cot='" + this.cot + "' is different from '" + cval + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!Str.compareStr(this.aui2, cval = comp.getAUI2())) {
            if (out != null) {
                out.println("this->aui2='" + this.aui2 + "' is different from '" + cval + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (this.cof != (ival = comp.getCOF())) {
            if (out != null) {
                out.println("this->cof='" + this.cof + "' is different from '" + ival + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        QualifierFrequencyVector quals = comp.getQualifiers();
        if (this.qualifiers == null && quals != null || this.qualifiers != null && quals == null) {
            if (out != null) {
                out.println("QualifierFrequencies are different");
            }
            return false;
        }
        if (this.qualifiers == null && quals == null) {
            return ret;
        }
        if (this.qualifiers.size() != quals.size()) {
            if (out != null) {
                out.println("QualifierFrequencies sizes are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        ret = equalsFlag ? (ret &= this.qualifiers.equals(quals, out)) : (ret &= this.qualifiers.equivalent(quals, out));
        return ret;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, QualifierFrequency> table = new Hashtable<String, QualifierFrequency>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            QualifierFrequency val = (QualifierFrequency)iter.next();
            table.put(val.getKey(), val);
        }
        return table;
    }

    public String getKey() {
        return this.source.getSAB() + this.aui2 + this.cot;
    }
}

