/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.cooccurrence;

import gov.nih.nlm.kss.models.KSCuiVector;
import gov.nih.nlm.kss.models.meta.cooccurrence.CooccurringConcept;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class CooccurrenceVector
extends KSCuiVector {
    public static final String XmlName = "CooccurrenceCollection";
    public static final String XmlStructure = "1.0";

    public CooccurrenceVector(Vector cooccurrences) {
        super(cooccurrences, XmlName, XmlStructure);
    }

    public CooccurrenceVector(CooccurrenceVector cooccurrences) {
        super(cooccurrences, XmlName, XmlStructure);
    }

    public CooccurrenceVector() {
        super(XmlName, XmlStructure);
    }

    public CooccurrenceVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        super.parse(root, namespace);
        Element cui1Child = root.getChild("cui", namespace);
        if (cui1Child == null) {
            throw new XMLException("No concept unique identifier for the first concept in the cooccurring concept");
        }
        String cui1 = XMLInterpreter.extractString(cui1Child);
        String childName = "cooccurrence";
        List coocs = root.getChildren(childName, namespace);
        if (coocs == null || coocs.size() == 0) {
            return;
        }
        int i = 0;
        while (i < coocs.size()) {
            Element coocEle = (Element)coocs.get(i);
            CooccurringConcept cooc = new CooccurringConcept(cui1, coocEle, namespace);
            if (cooc == null) {
                throw new XMLException("Invalid cooccurring concept definition");
            }
            this.add(cooc);
            ++i;
        }
    }

    public static CooccurrenceVector getInstance(String xml) {
        CooccurrenceVector aev = null;
        try {
            aev = new CooccurrenceVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.cooccurrence.CooccurrenceVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            CooccurrenceVector vec = CooccurrenceVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No cooccurrence read");
                return;
            }
            System.out.println("Number of cooccurrences: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                CooccurringConcept cooc = (CooccurringConcept)iter.next();
                System.out.println("CooccurringConcept----------------");
                cooc.output();
                System.out.println("CooccurringConcept END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

