/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.cooccurrence;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.concept.Concept;
import gov.nih.nlm.kss.models.meta.cooccurrence.COContext;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class CooccurringConcept
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private String cui1;
    private String aui1;
    private Concept con1;
    private String cui2;
    private Concept con2;
    private Vector coContexts;
    private boolean performance = false;
    public static final String XmlName = "cooccurrence";

    public CooccurringConcept() {
        this.con1 = null;
        this.con2 = null;
        this.aui1 = null;
        this.coContexts = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public CooccurringConcept(Concept con1, Concept con2) {
        this.con1 = con1;
        this.con2 = con2;
        this.aui1 = null;
        this.coContexts = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public CooccurringConcept(String cui1, Element cooc, Namespace namespace) throws XMLException {
        Element cui2Child;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        this.con1 = null;
        this.cui1 = cui1;
        Element aui1Child = cooc.getChild("aui1", namespace);
        if (aui1Child != null) {
            this.aui1 = XMLInterpreter.extractString(aui1Child);
        }
        if ((cui2Child = cooc.getChild("cui2", namespace)) == null) {
            throw new XMLException("No second concept unique identifier <cui2> found");
        }
        this.cui2 = XMLInterpreter.extractString(cui2Child);
        Element cn2Child = cooc.getChild("cn2", namespace);
        if (cn2Child == null) {
            throw new XMLException("No second concept name <cn2> found");
        }
        String cn2 = XMLInterpreter.extractString(cn2Child);
        this.con2 = new Concept(this.cui2, cn2);
        List cocxts = cooc.getChildren("source", namespace);
        Vector<COContext> vec = new Vector<COContext>();
        int i = 0;
        while (i < cocxts.size()) {
            Element cocont = (Element)cocxts.get(i);
            COContext t = new COContext(cocont, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse cooccurrence context\n");
            }
            vec.add(t);
            ++i;
        }
        this.setCoContexts(vec);
    }

    public static CooccurringConcept getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("cooccurrence must be the name of the first element");
            }
            return new CooccurringConcept("", root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public Concept getCon1() {
        return this.con1;
    }

    public String getCUI1() {
        if (this.con1 == null) {
            return this.cui1;
        }
        return this.con1.getCUI();
    }

    public void setCon1(Concept c1) {
        this.con1 = c1;
    }

    public Concept getCon2() {
        return this.con2;
    }

    public String getCUI2() {
        if (this.con2 == null) {
            return this.cui2;
        }
        return this.con2.getCUI();
    }

    public String getAUI1() {
        return this.aui1;
    }

    public void setAUI1(String aui1) {
        this.aui1 = aui1;
    }

    public void setCon2(Concept c2) {
        this.con2 = c2;
    }

    public Vector getCoContexts() {
        return this.coContexts;
    }

    public void setCoContexts(Vector coContexts) {
        this.coContexts = coContexts;
    }

    public void addCoContext(COContext cxt) {
        if (this.coContexts == null) {
            this.coContexts = new Vector();
        }
        this.coContexts.addElement(cxt);
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        String tab = "   ";
        out.println("");
        out.println("CoOccurring Concepts:      ");
        out.println(tab + "Name:     " + this.con2.getCN());
        out.println(tab + "AUI :     " + this.getAUI1());
        out.println(tab + "CoOccurring Contexts:      ");
        Vector cocs = this.getCoContexts();
        if (cocs == null) {
            return;
        }
        Iterator vIter = cocs.iterator();
        while (vIter.hasNext()) {
            ((COContext)vIter.next()).output();
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(10000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        CooccurringConcept.xmlize(xml, this.con2.getCUI(), this.con2.getCN(), this.getCoContexts());
    }

    public static void xmlize(StringBuffer xml, String cui2, String cn2, Vector cocontexts) {
        CooccurringConcept.xmlize(xml, null, cui2, cn2, cocontexts);
    }

    public static void xmlize(StringBuffer xml, String aui1, String cui2, String cn2, Vector cocontexts) {
        String tab0 = "      ";
        String tab = "         ";
        xml.ensureCapacity(xml.length() + 350);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        if (aui1 != null && !aui1.equals("")) {
            xml.append(tab);
            xml.append("<aui1>");
            xml.append(Str.escape(aui1));
            xml.append("</aui1>\n");
        }
        xml.append(tab);
        xml.append("<cui2>");
        xml.append(cui2);
        xml.append("</cui2>\n");
        xml.append(tab);
        xml.append("<cn2>");
        xml.append(Str.escape(cn2));
        xml.append("</cn2>\n");
        Iterator vIter = cocontexts.iterator();
        while (vIter.hasNext()) {
            ((COContext)vIter.next()).xmlize(xml);
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String cval;
        if (!(c instanceof CooccurringConcept)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        CooccurringConcept comp = (CooccurringConcept)c;
        boolean ret = true;
        String cui1 = this.getCUI1();
        if (!Str.compareStr(cui1, cval = comp.getCUI1())) {
            if (out != null) {
                out.println("this->cui1='" + cui1 + "' is different from '" + cval + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!Str.compareStr(this.getAUI1(), comp.getAUI1())) {
            if (out != null) {
                out.println("this->aui1='" + this.getAUI1() + "' is different from '" + comp.getAUI1() + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Vector cocxts = comp.getCoContexts();
        if (this.coContexts == null && cocxts != null || this.coContexts != null && cocxts == null) {
            if (out != null) {
                out.println("COContexts are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (this.coContexts == null && cocxts == null) {
            return ret;
        }
        if (this.coContexts.size() != cocxts.size()) {
            if (out != null) {
                out.println("COContexts are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Hashtable compht = this.convert(cocxts);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(this.coContexts);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            COContext val = (COContext)thisht.get(compkey);
            if (val == null) {
                if (out != null) {
                    COContext missing = (COContext)compht.get(compkey);
                    out.println("COContext missing from this instance:");
                    out.println(missing.xmlize());
                }
                ret = false;
                if (!this.performance) continue;
                return ret;
            }
            COContext val2 = (COContext)compht.get(compkey);
            if (equalsFlag) {
                if (!val.equals(val2, out)) {
                    ret = false;
                    if (this.performance) {
                        return ret;
                    }
                }
            } else if (!val.equivalent(val2, out)) {
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (this.performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            COContext val = (COContext)thisht.get(thiskey);
            if (out == null) continue;
            COContext added = (COContext)thisht.get(thiskey);
            out.println("COContext added to this instance:");
            out.println(added.xmlize());
        }
        return ret;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, COContext> table = new Hashtable<String, COContext>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            COContext val = (COContext)iter.next();
            table.put(val.getKey(), val);
        }
        return table;
    }

    public String getKey() {
        if (this.aui1 != null) {
            return this.aui1 + this.cui1 + this.cui2;
        }
        return this.cui1 + this.cui2;
    }
}

