/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.cooccurrence;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.cooccurrence.MeSHQualifier;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class QualifierFrequency
extends XMLInterpreter
implements Serializable,
KSComparable,
Xmlizable {
    public static final String XmlName = "qualifiers";
    private MeSHQualifier qualifier;
    private String frequency;

    public QualifierFrequency() {
        this.qualifier = null;
        this.frequency = "";
    }

    public QualifierFrequency(MeSHQualifier qual, String freq) {
        this.qualifier = qual;
        this.frequency = freq;
    }

    public QualifierFrequency(Element qf, Namespace namespace) throws XMLException {
        Element codeChild = qf.getChild("code");
        if (codeChild == null) {
            throw new XMLException("No MeSH code <code> found");
        }
        String code = XMLInterpreter.extractString(codeChild);
        Element nameChild = qf.getChild("name");
        if (nameChild == null) {
            throw new XMLException("No MeSH name <name> found");
        }
        String name = XMLInterpreter.extractString(nameChild);
        this.qualifier = new MeSHQualifier(code, name);
        Element freqChild = qf.getChild("freq");
        if (freqChild == null) {
            throw new XMLException("No frequency <freq> found");
        }
        this.frequency = XMLInterpreter.extractString(freqChild);
    }

    public static QualifierFrequency getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("qualifiers must be the name of the first element");
            }
            return new QualifierFrequency(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setQualifier(MeSHQualifier qualifier) {
        this.qualifier = qualifier;
    }

    public MeSHQualifier getQualifier() {
        return this.qualifier;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        String tab = "         ";
        out.println("");
        out.println(tab + "Code:       " + this.getQualifier().getCode());
        out.println(tab + "Name:       " + this.getQualifier().getName());
        out.println(tab + "Freq:       " + this.getFrequency());
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        QualifierFrequency.xmlize(xml, this.getQualifier(), this.getFrequency());
    }

    public static void xmlize(StringBuffer xml, MeSHQualifier qual, String frequency) {
        if (qual == null) {
            return;
        }
        String tab0 = "            ";
        String tab = "               ";
        xml.ensureCapacity(xml.length() + 420);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.append("<code>");
        xml.append(Str.escape(qual.getCode()));
        xml.append("</code>\n");
        xml.append(tab);
        xml.append("<name>");
        xml.append(Str.escape(qual.getName()));
        xml.append("</name>\n");
        xml.append(tab);
        xml.append("<freq>");
        xml.append(frequency);
        xml.append("</freq>\n");
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof QualifierFrequency)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        QualifierFrequency comp = (QualifierFrequency)c;
        boolean ret = true;
        if (!this.qualifier.equals(comp.getQualifier(), out)) {
            if (out != null) {
                out.println("this->MeSHQualifier is different from the comparison instance");
            }
            ret = false;
        }
        if (!Str.compareStr(this.frequency, comp.getFrequency())) {
            if (out != null) {
                out.println("this->Frequency='" + this.frequency + "' is different from '" + comp.getFrequency() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.qualifier.getKey();
    }
}

