/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.deltas;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class ConceptDelta
extends XMLInterpreter
implements Serializable,
KSComparable,
Xmlizable {
    public static final int DELETION = 0;
    public static final int MERGE = 1;
    public static final int BROADER = 2;
    public static final int NARROWER = 3;
    public static final int OTHER = 4;
    private String cui;
    private int change;
    private String mergeCUI;
    public static final String XmlName = "change";

    public ConceptDelta() {
        this.cui = "";
        this.change = 0;
        this.mergeCUI = null;
    }

    public ConceptDelta(String cui) {
        this.cui = cui;
        this.change = 0;
        this.mergeCUI = null;
    }

    public ConceptDelta(String cui, int change, String mergeCUI) {
        this.cui = cui;
        this.change = change;
        this.mergeCUI = mergeCUI;
    }

    public ConceptDelta(Element conceptChange, Namespace namespace) throws XMLException {
        Element cuiChild = conceptChange.getChild("cui", namespace);
        if (cuiChild == null) {
            throw new XMLException("No concept unique identifier <cui> found");
        }
        this.cui = XMLInterpreter.extractString(cuiChild);
        Element delChild = conceptChange.getChild("delete", namespace);
        Element mergeChild = conceptChange.getChild("merge", namespace);
        Element broadChild = conceptChange.getChild("broader", namespace);
        Element narrowChild = conceptChange.getChild("narrower", namespace);
        Element otherChild = conceptChange.getChild("otherRelated", namespace);
        if (delChild != null) {
            this.change = 0;
        } else if (mergeChild != null) {
            this.change = 1;
        } else if (broadChild != null) {
            this.change = 2;
        } else if (narrowChild != null) {
            this.change = 3;
        } else if (otherChild != null) {
            this.change = 4;
        } else {
            throw new XMLException("No or invalid relationship option specified");
        }
        if (this.change != 0) {
            Element mcuiChild = conceptChange.getChild("mcui", namespace);
            if (mcuiChild == null) {
                throw new XMLException("No merge CUI <mcui> value specified");
            }
            this.mergeCUI = XMLInterpreter.extractString(mcuiChild);
        }
    }

    public static ConceptDelta getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("change must be the name of the first element");
            }
            return new ConceptDelta(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public String getCUI() {
        return this.cui;
    }

    public void setCUI(String cui) {
        this.cui = cui;
    }

    public String getMergeCUI() {
        return this.mergeCUI;
    }

    public void setMergeCUI(String cui) {
        this.mergeCUI = cui;
    }

    public int getChangeType() {
        return this.change;
    }

    public void setChangeType(int change) {
        if (change != 0 && change != 1 && change != 2 && change != 3 && change != 4) {
            this.change = 0;
            return;
        }
        this.change = change;
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        ConceptDelta.xmlize(xml, this.cui, this.change, this.mergeCUI);
    }

    protected static String xmlize(StringBuffer xml, String cui, int change, String mergeCUI) {
        String tab0 = "        ";
        String tab = "           ";
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.ensureCapacity(xml.length() + 100);
        xml.append("<cui>");
        xml.append(cui);
        xml.append("</cui>\n");
        xml.append(tab);
        switch (change) {
            case 1: {
                xml.append("<merge/>\n");
                break;
            }
            case 2: {
                xml.append("<broader/>\n");
                break;
            }
            case 4: {
                xml.append("<otherRelated/>\n");
                break;
            }
            case 3: {
                xml.append("<narrower/>\n");
                break;
            }
            case 0: {
                xml.append("<delete/>\n");
            }
        }
        if (mergeCUI != null) {
            xml.append(tab);
            xml.append("<mcui>");
            xml.append(mergeCUI);
            xml.append("</mcui>\n");
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
        return xml.toString();
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof ConceptDelta)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        ConceptDelta comp = (ConceptDelta)c;
        boolean ret = true;
        if (!Str.compareStr(this.cui, comp.getCUI())) {
            if (out != null) {
                out.println("this->CUI='" + this.cui + "' is different from '" + comp.getCUI() + "'");
            }
            ret = false;
        }
        if (this.change != comp.getChangeType()) {
            if (out != null) {
                out.println("this->changeType='" + this.change + "' different from '" + comp.getChangeType() + "'");
            }
            ret = false;
        }
        if (this.change != 0 && !Str.compareStr(this.mergeCUI, comp.getMergeCUI())) {
            if (out != null) {
                out.println("this->CUI='" + this.mergeCUI + "' is different from '" + comp.getMergeCUI() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.cui;
    }
}

