/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.deltas;

import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.meta.deltas.ConceptDelta;
import gov.nih.nlm.kss.models.meta.deltas.ReleaseDelta;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class ReleaseDeltaVector
extends KSVector {
    public static final String XmlName = "ReleaseDeltasCollection";
    public static final String XmlStructure = "1.0";

    public ReleaseDeltaVector(Vector deltas) {
        super(deltas, XmlName, XmlStructure);
    }

    public ReleaseDeltaVector(ReleaseDeltaVector deltas) {
        super(deltas, XmlName, XmlStructure);
    }

    public ReleaseDeltaVector() {
        super(XmlName, XmlStructure);
    }

    public ReleaseDeltaVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        String childName = "releaseDelta";
        List releaseDeltas = root.getChildren(childName, namespace);
        if (releaseDeltas == null || releaseDeltas.size() == 0) {
            return;
        }
        int i = 0;
        while (i < releaseDeltas.size()) {
            Element yrDelta = (Element)releaseDeltas.get(i);
            ReleaseDelta releaseDeltar = new ReleaseDelta(yrDelta, namespace);
            if (releaseDeltar == null) {
                throw new XMLException("Invalid release delta definition");
            }
            this.add(releaseDeltar);
            ++i;
        }
    }

    public static ReleaseDeltaVector getInstance(String xml) {
        ReleaseDeltaVector aev = null;
        try {
            aev = new ReleaseDeltaVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public void xmlize(StringBuffer xml) {
        xml.append(this.xmlize());
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.deltas.ReleaseDeltaVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            ReleaseDeltaVector vec = ReleaseDeltaVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No release deltas read");
                return;
            }
            System.out.println("Number of release deltas: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                ReleaseDelta releaseDelta = (ReleaseDelta)iter.next();
                System.out.println("ReleaseDelta----------------");
                out.println(releaseDelta.xmlize());
                System.out.println("ReleaseDelta END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
            Iterator iter3 = vec.iterator();
            System.out.print("    ");
            System.out.println(" MER DEL BRO NAR ORE");
            while (iter3.hasNext()) {
                ReleaseDelta rd = (ReleaseDelta)iter3.next();
                Vector deltas = rd.getDeltas();
                Iterator iter2 = deltas.iterator();
                boolean merge = false;
                boolean delete = false;
                boolean narrow = false;
                boolean broad = false;
                boolean other = false;
                while (iter2.hasNext()) {
                    ConceptDelta cd = (ConceptDelta)iter2.next();
                    switch (cd.getChangeType()) {
                        case 0: {
                            delete = true;
                            break;
                        }
                        case 1: {
                            merge = true;
                            break;
                        }
                        case 2: {
                            broad = true;
                            break;
                        }
                        case 3: {
                            narrow = true;
                            break;
                        }
                        case 4: {
                            other = true;
                        }
                    }
                }
                System.out.print(rd.getRelease());
                String val = "";
                val = merge ? "  X  " : "     ";
                System.out.print(val);
                val = delete ? " X  " : "     ";
                System.out.print(val);
                val = broad ? " X  " : "     ";
                System.out.print(val);
                val = narrow ? " X  " : "     ";
                System.out.print(val);
                val = other ? " X  " : "     ";
                System.out.print(val);
                System.out.println();
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

